/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.exception.handler;

import java.sql.SQLException;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.util.Srl;

public class SQLExceptionAdviser {
    public String askAdvice(SQLException sqlEx, DBDef dbdef) {
        if (sqlEx == null || dbdef == null) {
            return null;
        }
        if (DBDef.MySQL.equals((Object)dbdef)) {
            if (this.hasMessageHint(sqlEx, "Communications link failure")) {
                return "And also check the MySQL bootstrap and network.";
            }
            if (this.hasMessageHint(sqlEx, "Field", "doesn't have a default value")) {
                return "And also check the insert values to not-null columns.";
            }
            if (this.hasMessageHint(sqlEx, "Column", "cannot be null")) {
                return "And also check the update values to not-null columns.";
            }
        } else if (DBDef.DB2.equals((Object)dbdef)) {
            if (this.hasMessageHint(sqlEx, "SQLCODE=-302")) {
                return "Is it column size-over?";
            }
            if (this.hasMessageHint(sqlEx, "SQLCODE=-407")) {
                return "Is it not-null constraint?";
            }
            if (this.hasMessageHint(sqlEx, "SQLCODE=-530")) {
                return "Is it FK constraint?";
            }
            if (this.hasMessageHint(sqlEx, "SQLCODE=-952")) {
                return "Is it timeout?";
            }
        }
        return null;
    }

    protected boolean hasMessageHint(SQLException sqlEx, String ... hints) {
        String msg = sqlEx.getMessage();
        if (msg != null && Srl.containsAll(msg, hints)) {
            return true;
        }
        SQLException nextEx = sqlEx.getNextException();
        if (nextEx == null) {
            return false;
        }
        msg = nextEx.getMessage();
        if (msg != null && Srl.containsAll(msg, hints)) {
            return true;
        }
        SQLException nextNextEx = nextEx.getNextException();
        if (nextNextEx == null) {
            return false;
        }
        msg = nextNextEx.getMessage();
        return msg != null && Srl.containsAll(msg, hints);
    }
}

