/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.infra.core.logic;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DfSchemaResourceFinder {
    protected final Set<String> _prefixSet = new LinkedHashSet<String>(4);
    protected final Set<String> _suffixSet = new LinkedHashSet<String>(4);
    protected boolean _oneLevelNested;

    public List<File> findResourceFileList(String targetDir) {
        ArrayList<File> resourceFileList;
        File baseDir = new File(targetDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return DfSchemaResourceFinder.this.matchName(name, DfSchemaResourceFinder.this._prefixSet, false) && DfSchemaResourceFinder.this.matchName(name, DfSchemaResourceFinder.this._suffixSet, true);
            }
        };
        Comparator<File> fileNameAscComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<File> treeSet = new TreeSet<File>(fileNameAscComparator);
        String[] targetList = baseDir.list(filter);
        if (targetList != null) {
            File[] listDirs;
            for (String targetFileName : targetList) {
                String targetFilePath = targetDir + "/" + targetFileName;
                treeSet.add(new File(targetFilePath));
            }
            resourceFileList = new ArrayList<File>(treeSet);
            if (this._oneLevelNested && (listDirs = baseDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) != null) {
                for (File dir : listDirs) {
                    String nestedDir = targetDir + "/" + dir.getName();
                    List<File> nestedFileList = this.findResourceFileList(nestedDir);
                    resourceFileList.addAll(nestedFileList);
                }
            }
        } else {
            resourceFileList = new ArrayList<File>();
        }
        return resourceFileList;
    }

    protected boolean matchName(String name, Set<String> set, boolean suffix) {
        if (set.isEmpty()) {
            return true;
        }
        for (String key : set) {
            if (!(suffix ? name.endsWith(key) : name.startsWith(key))) continue;
            return true;
        }
        return false;
    }

    public void addPrefix(String prefix) {
        if (prefix != null) {
            this._prefixSet.add(prefix);
        }
    }

    public void addSuffix(String suffix) {
        if (suffix != null) {
            this._suffixSet.add(suffix);
        }
    }

    public void containsOneLevelNested() {
        this._oneLevelNested = true;
    }
}

