/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.infra.dfprop;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.seasar.dbflute.helper.mapstring.MapListFile;
import org.seasar.dbflute.util.Srl;

public class DfPropPublicMap {
    protected static final String DBFLUTE_LATEST_VERSION = "dbflute.latest.version";
    protected static final String DBFLUTE_LATEST_SNAPSHOT_VERSION = "dbflute.latest.snapshot.version";
    protected static final String DBFLUTE_DOWNLOAD_URL = "dbflute.download.url";
    protected static final String INTRO_DOWNLOAD_URL = "intro.download.url";
    protected static final String DEFAULT_DFPROP_URL = "http://dbflute.seasar.org/meta/publicMap.dfprop";
    protected static final String VERSION_SUFFIX_VARIABLE = "$$versionSuffix$$";
    protected Map<String, Object> _map;
    protected String _specifiedUrl;

    public void loadMap() {
        String siteUrl = this.getPublicMapUrl();
        InputStream ins = null;
        try {
            URL url = new URL(siteUrl);
            ins = url.openStream();
            MapListFile mapListFile = new MapListFile();
            this._map = mapListFile.readMap(ins);
        }
        catch (IOException e) {
            throw new IllegalStateException("The url threw the IO exception: url=" + siteUrl, e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public String getDBFluteLatestVersion() {
        return this.getMetaValue(DBFLUTE_LATEST_VERSION);
    }

    public String getDBFluteLatestSnapshotVersion() {
        return this.getMetaValue(DBFLUTE_LATEST_SNAPSHOT_VERSION);
    }

    public String getDBFluteDownloadUrl(String downloadVersion) {
        String key = DBFLUTE_DOWNLOAD_URL;
        String downloadUrl = this.getMetaValue(DBFLUTE_DOWNLOAD_URL);
        if (downloadUrl == null) {
            String msg = "Not found the property: key=dbflute.download.url, map=" + this._map;
            throw new IllegalStateException(msg);
        }
        return this.buildDBFluteDownloadUrl(downloadUrl, downloadVersion);
    }

    protected String buildDBFluteDownloadUrl(String downloadUrl, String downloadVersion) {
        String toStr = Srl.is_NotNull_and_NotTrimmedEmpty(downloadVersion) ? "-" + downloadVersion : "";
        return Srl.replace(downloadUrl, VERSION_SUFFIX_VARIABLE, toStr);
    }

    public String getIntroDownloadUrl() {
        return this.getMetaValue(INTRO_DOWNLOAD_URL);
    }

    protected String getMetaValue(String key) {
        return (String)this._map.get(key);
    }

    protected String getPublicMapUrl() {
        return this._specifiedUrl != null ? this._specifiedUrl : DEFAULT_DFPROP_URL;
    }

    public DfPropPublicMap specifyUrl(String url) {
        this._specifiedUrl = url;
        return this;
    }
}

