/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;

public class TnStatementFactoryImpl
implements StatementFactory {
    private static final Log _log = LogFactory.getLog(TnStatementFactoryImpl.class);
    protected StatementConfig _defaultStatementConfig;
    protected boolean _internalDebug;
    protected Integer _cursorSelectFetchSize;

    @Override
    public PreparedStatement createPreparedStatement(Connection conn, String sql) {
        StatementConfig config = this.findStatementConfigOnThread();
        int resultSetType = this.getResultSetType(config);
        int resultSetConcurrency = this.getResultSetConcurrency(config);
        if (this.isInternalDebugEnabled()) {
            _log.debug((Object)("...Preparing statement:(sql, " + resultSetType + ", " + resultSetConcurrency + ")"));
        }
        PreparedStatement ps = this.prepareStatement(conn, sql, resultSetType, resultSetConcurrency);
        this.reflectStatementOptions(ps, config);
        return ps;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to prepare the SQL statement.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected StatementConfig findStatementConfigOnThread() {
        StatementConfig config;
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
            config = cb.getStatementConfig();
        } else if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            config = context.getStatementConfig();
        } else {
            config = InternalMapContext.getUpdateStatementConfig();
        }
        return config;
    }

    protected int getResultSetType(StatementConfig config) {
        int resultSetType;
        if (config != null && config.hasResultSetType()) {
            resultSetType = config.getResultSetType();
        } else {
            int defaultType = 1003;
            resultSetType = this._defaultStatementConfig != null && this._defaultStatementConfig.hasResultSetType() ? (config != null && config.isSuppressDefault() ? 1003 : this._defaultStatementConfig.getResultSetType()) : 1003;
        }
        return resultSetType;
    }

    protected int getResultSetConcurrency(StatementConfig config) {
        return 1007;
    }

    protected void reflectStatementOptions(PreparedStatement ps, StatementConfig config) {
        StatementConfig actualConfig = this.getActualStatementConfig(config);
        this.doReflectStatementOptions(ps, actualConfig);
    }

    protected StatementConfig getActualStatementConfig(StatementConfig config) {
        boolean existsRequest = config != null;
        StatementConfig defaultConfig = this.getActualDefaultConfig(config);
        boolean existsDefault = defaultConfig != null;
        Integer cursorSelectFetchSize = this.getActualCursorSelectFetchSize(config);
        boolean existsCursor = cursorSelectFetchSize != null;
        Integer queryTimeout = this.getActualQueryTimeout(config, existsRequest, defaultConfig, existsDefault);
        Integer fetchSize = this.getActualFetchSize(config, existsRequest, cursorSelectFetchSize, existsCursor, defaultConfig, existsDefault);
        Integer maxRows = this.getActualMaxRows(config, existsRequest, defaultConfig, existsDefault);
        if (queryTimeout == null && fetchSize == null && maxRows == null) {
            return null;
        }
        StatementConfig actualConfig = new StatementConfig();
        actualConfig.queryTimeout(queryTimeout).fetchSize(fetchSize).maxRows(maxRows);
        return actualConfig;
    }

    protected StatementConfig getActualDefaultConfig(StatementConfig config) {
        Object defaultConfig = this._defaultStatementConfig != null ? (config != null && config.isSuppressDefault() ? null : this._defaultStatementConfig.createSnapshot()) : null;
        return defaultConfig;
    }

    protected Integer getActualCursorSelectFetchSize(StatementConfig config) {
        if (config != null && config.isSuppressDefault()) {
            return null;
        }
        return this._cursorSelectFetchSize;
    }

    protected Integer getActualQueryTimeout(StatementConfig config, boolean existsRequest, StatementConfig defaultConfig, boolean existsDefault) {
        Integer queryTimeout = existsRequest && config.hasQueryTimeout() ? config.getQueryTimeout() : (existsDefault && defaultConfig.hasQueryTimeout() ? defaultConfig.getQueryTimeout() : null);
        return queryTimeout;
    }

    protected Integer getActualFetchSize(StatementConfig config, boolean existsRequest, Integer cursorSelectFetchSize, boolean existsCursor, StatementConfig defaultConfig, boolean existsDefault) {
        Integer fetchSize = existsRequest && config.hasFetchSize() ? config.getFetchSize() : (existsCursor && this.isSelectCursorCommand() ? cursorSelectFetchSize : (existsDefault && defaultConfig.hasFetchSize() ? defaultConfig.getFetchSize() : null));
        return fetchSize;
    }

    protected Integer getActualMaxRows(StatementConfig config, boolean existsRequest, StatementConfig defaultConfig, boolean existsDefault) {
        Integer maxRows = existsRequest && config.hasMaxRows() ? config.getMaxRows() : (existsDefault && defaultConfig.hasMaxRows() ? defaultConfig.getMaxRows() : null);
        return maxRows;
    }

    protected void doReflectStatementOptions(PreparedStatement ps, StatementConfig actualConfig) {
        if (actualConfig == null || !actualConfig.hasStatementOptions()) {
            return;
        }
        try {
            if (actualConfig.hasQueryTimeout()) {
                Integer queryTimeout = actualConfig.getQueryTimeout();
                if (this.isInternalDebugEnabled()) {
                    _log.debug((Object)("...Setting queryTimeout of statement: " + queryTimeout));
                }
                ps.setQueryTimeout(queryTimeout);
            }
            if (actualConfig.hasFetchSize()) {
                Integer fetchSize = actualConfig.getFetchSize();
                if (this.isInternalDebugEnabled()) {
                    _log.debug((Object)("...Setting fetchSize of statement: " + fetchSize));
                }
                ps.setFetchSize(fetchSize);
            }
            if (actualConfig.hasMaxRows()) {
                Integer maxRows = actualConfig.getMaxRows();
                if (this.isInternalDebugEnabled()) {
                    _log.debug((Object)("...Setting maxRows of statement: " + maxRows));
                }
                ps.setMaxRows(maxRows);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set the JDBC parameter.");
            this.handleSQLException(e, resource);
        }
    }

    @Override
    public CallableStatement createCallableStatement(Connection conn, String sql) {
        StatementConfig config = this.findStatementConfigOnThread();
        int resultSetType = this.getResultSetType(config);
        int resultSetConcurrency = this.getResultSetConcurrency(config);
        if (this.isInternalDebugEnabled()) {
            _log.debug((Object)("...Preparing callable:(sql, " + resultSetType + ", " + resultSetConcurrency + ")"));
        }
        CallableStatement cs = this.prepareCall(conn, sql, resultSetType, resultSetConcurrency);
        this.reflectStatementOptions(cs, config);
        return cs;
    }

    protected CallableStatement prepareCall(Connection conn, String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to prepare the procedure statement.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
        this.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected SQLExceptionResource createSQLExceptionResource() {
        return new SQLExceptionResource();
    }

    protected boolean isSelectCursorCommand() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        return ResourceContext.behaviorCommand().isSelectCursor();
    }

    private boolean isInternalDebugEnabled() {
        return this._internalDebug && _log.isDebugEnabled();
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }

    public void setCursorSelectFetchSize(Integer cursorSelectFetchSize) {
        this._cursorSelectFetchSize = cursorSelectFetchSize;
    }
}

