/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rowcreator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationKey;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationSelector;

public class TnRelationRowCreationResource {
    protected ResultSet _resultSet;
    protected Object _row;
    protected TnRelationPropertyType _relationPropertyType;
    protected Map<String, String> _selectColumnMap;
    protected Map<String, Map<String, Integer>> _selectIndexMap;
    protected TnRelationKey _relationKey;
    protected Map<String, Map<String, TnPropertyMapping>> _relPropCache;
    protected TnRelationRowCache _relRowCache;
    protected TnRelationSelector _relSelector;
    protected String _baseSuffix;
    protected String _relationNoSuffix;
    protected int _limitRelationNestLevel;
    protected int _currentRelationNestLevel;
    protected TnPropertyMapping _currentPropertyMapping;
    protected int _validValueCount;
    protected boolean _createDeadLink;
    protected Stack<TnRelationPropertyType> _relationPropertyTypeBackup;
    protected Stack<TnRelationKey> _relationKeyBackup;
    protected Stack<String> _baseSuffixBackup;
    protected Stack<String> _relationSuffixBackup;

    public boolean hasRowInstance() {
        return this._row != null;
    }

    public void clearRowInstance() {
        this._row = null;
    }

    public TnBeanMetaData getRelationBeanMetaData() {
        return this._relationPropertyType.getYourBeanMetaData();
    }

    protected boolean hasNextRelationProperty() {
        return this.getRelationBeanMetaData().getRelationPropertyTypeSize() > 0;
    }

    protected void backupRelationPropertyType() {
        this.getRelationPropertyTypeBackup().push(this.getRelationPropertyType());
    }

    protected void restoreRelationPropertyType() {
        this.setRelationPropertyType(this.getRelationPropertyTypeBackup().pop());
    }

    protected Stack<TnRelationPropertyType> getRelationPropertyTypeBackup() {
        if (this._relationPropertyTypeBackup == null) {
            this._relationPropertyTypeBackup = new Stack();
        }
        return this._relationPropertyTypeBackup;
    }

    public boolean containsSelectColumn(String columnKeyName) {
        return this._selectColumnMap.containsKey(columnKeyName);
    }

    public boolean containsRelationKeyColumn(String columnName) {
        return this._relationKey.containsColumn(columnName);
    }

    public Object extractRelationKeyValue(String columnName) {
        return this._relationKey.extractKeyValue(columnName);
    }

    protected void backupRelationKey() {
        this.getRelationKeyBackup().push(this.getRelationKey());
    }

    protected void restoreRelationKey() {
        this.setRelationKey(this.getRelationKeyBackup().pop());
    }

    protected Stack<TnRelationKey> getRelationKeyBackup() {
        if (this._relationKeyBackup == null) {
            this._relationKeyBackup = new Stack();
        }
        return this._relationKeyBackup;
    }

    public void initializePropertyCacheElement() {
        this._relPropCache.put(this._relationNoSuffix, new HashMap());
    }

    public boolean hasPropertyCacheElement() {
        Map<String, TnPropertyMapping> propertyCacheElement = this.extractPropertyCacheElement();
        return propertyCacheElement != null && !propertyCacheElement.isEmpty();
    }

    public Map<String, TnPropertyMapping> extractPropertyCacheElement() {
        return this._relPropCache.get(this._relationNoSuffix);
    }

    public void savePropertyCacheElement() {
        String columnName;
        Map<String, TnPropertyMapping> propertyCacheElement;
        if (!this.hasPropertyCacheElement()) {
            this.initializePropertyCacheElement();
        }
        if ((propertyCacheElement = this.extractPropertyCacheElement()).containsKey(columnName = this.buildRelationColumnName())) {
            return;
        }
        propertyCacheElement.put(columnName, this._currentPropertyMapping);
    }

    public TnRelationKey prepareRelationKey() throws SQLException {
        TnRelationKey relKey = this.doCreateRelationKey();
        if (relKey != null) {
            this.setRelationKey(relKey);
        }
        return relKey;
    }

    protected TnRelationKey doCreateRelationKey() throws SQLException {
        return this._relRowCache.createRelationKey(this._resultSet, this._relationPropertyType, this._selectColumnMap, this._selectIndexMap, this._relationNoSuffix);
    }

    public String buildRelationColumnName() {
        return this._currentPropertyMapping.getColumnDbName() + this._relationNoSuffix;
    }

    protected void addRelationNoSuffix(String additionalRelationNoSuffix) {
        this._relationNoSuffix = this._relationNoSuffix + additionalRelationNoSuffix;
    }

    protected void backupBaseSuffix() {
        this.getBaseSuffixBackup().push(this.getBaseSuffix());
    }

    protected void restoreBaseSuffix() {
        this.setBaseSuffix(this.getBaseSuffixBackup().pop());
    }

    protected Stack<String> getBaseSuffixBackup() {
        if (this._baseSuffixBackup == null) {
            this._baseSuffixBackup = new Stack();
        }
        return this._baseSuffixBackup;
    }

    protected void backupRelationNoSuffix() {
        this.getRelationNoSuffixBackup().push(this.getRelationNoSuffix());
    }

    protected void restoreRelationNoSuffix() {
        this.setRelationNoSuffix(this.getRelationNoSuffixBackup().pop());
    }

    protected Stack<String> getRelationNoSuffixBackup() {
        if (this._relationSuffixBackup == null) {
            this._relationSuffixBackup = new Stack();
        }
        return this._relationSuffixBackup;
    }

    protected boolean isNextRelationUnderLimit() {
        return this._currentRelationNestLevel < this._limitRelationNestLevel;
    }

    protected void incrementCurrentRelationNestLevel() {
        ++this._currentRelationNestLevel;
    }

    protected void decrementCurrentRelationNestLevel() {
        --this._currentRelationNestLevel;
    }

    public void incrementValidValueCount() {
        ++this._validValueCount;
    }

    public void clearValidValueCount() {
        this._validValueCount = 0;
    }

    public boolean hasValidValueCount() {
        return this._validValueCount > 0;
    }

    public void prepareNextLevelMapping() {
        this.backupRelationPropertyType();
        this.backupRelationKey();
        this.incrementCurrentRelationNestLevel();
    }

    public void closeNextLevelMapping() {
        this.restoreRelationPropertyType();
        this.restoreRelationKey();
        this.decrementCurrentRelationNestLevel();
    }

    public void prepareNextRelationProperty(TnRelationPropertyType nextRpt) {
        this.backupBaseSuffix();
        this.backupRelationNoSuffix();
        this.clearRowInstance();
        this.setRelationPropertyType(nextRpt);
        this.setBaseSuffix(this._relationNoSuffix);
        this.addRelationNoSuffix(nextRpt.getRelationNoSuffixPart());
    }

    public void closeNextRelationProperty() {
        this.restoreBaseSuffix();
        this.restoreRelationNoSuffix();
    }

    public boolean isStopNextRelationMapping() {
        if (!this.hasNextRelationProperty()) {
            return true;
        }
        if (!this.isNonLimitMapping() && !this.isNextRelationUnderLimit()) {
            return true;
        }
        return this.isNonSelectedNextConnectingRelation();
    }

    public boolean isStopCurrentRelationMapping() {
        return this.isNonSelectedRelation();
    }

    protected boolean isNonLimitMapping() {
        return this._relSelector.isNonLimitMapping();
    }

    protected boolean isNonSelectedRelation() {
        return this._relSelector.isNonSelectedRelation(this._relationNoSuffix);
    }

    protected boolean isNonSelectedNextConnectingRelation() {
        return this._relSelector.isNonSelectedNextConnectingRelation(this._relationNoSuffix);
    }

    public boolean canUseRelationCache() {
        return this._relSelector.canUseRelationCache(this._relationNoSuffix);
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this._resultSet = resultSet;
    }

    public Object getRow() {
        return this._row;
    }

    public void setRow(Object row) {
        this._row = row;
    }

    public TnRelationPropertyType getRelationPropertyType() {
        return this._relationPropertyType;
    }

    public void setRelationPropertyType(TnRelationPropertyType rpt) {
        this._relationPropertyType = rpt;
    }

    public Map<String, String> getSelectColumnMap() {
        return this._selectColumnMap;
    }

    public void setSelectColumnMap(Map<String, String> selectColumnMap) {
        this._selectColumnMap = selectColumnMap;
    }

    public Map<String, Map<String, Integer>> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    public void setSelectIndexMap(Map<String, Map<String, Integer>> selectIndexMap) {
        this._selectIndexMap = selectIndexMap;
    }

    public TnRelationKey getRelationKey() {
        return this._relationKey;
    }

    public void setRelationKey(TnRelationKey relationKey) {
        this._relationKey = relationKey;
    }

    public Map<String, Map<String, TnPropertyMapping>> getRelPropCache() {
        return this._relPropCache;
    }

    public void setRelPropCache(Map<String, Map<String, TnPropertyMapping>> relPropCache) {
        this._relPropCache = relPropCache;
    }

    public TnRelationRowCache getRelRowCache() {
        return this._relRowCache;
    }

    public void setRelRowCache(TnRelationRowCache relRowCache) {
        this._relRowCache = relRowCache;
    }

    public String getBaseSuffix() {
        return this._baseSuffix;
    }

    public void setBaseSuffix(String baseSuffix) {
        this._baseSuffix = baseSuffix;
    }

    public String getRelationNoSuffix() {
        return this._relationNoSuffix;
    }

    public void setRelationNoSuffix(String relationNoSuffix) {
        this._relationNoSuffix = relationNoSuffix;
    }

    public int getLimitRelationNestLevel() {
        return this._limitRelationNestLevel;
    }

    public void setLimitRelationNestLevel(int limitRelationNestLevel) {
        this._limitRelationNestLevel = limitRelationNestLevel;
    }

    public int getCurrentRelationNestLevel() {
        return this._currentRelationNestLevel;
    }

    public void setCurrentRelationNestLevel(int currentRelationNestLevel) {
        this._currentRelationNestLevel = currentRelationNestLevel;
    }

    public TnPropertyMapping getCurrentPropertyMapping() {
        return this._currentPropertyMapping;
    }

    public void setCurrentPropertyType(TnPropertyMapping propertyType) {
        this._currentPropertyMapping = propertyType;
    }

    public boolean isCreateDeadLink() {
        return this._createDeadLink;
    }

    public void setCreateDeadLink(boolean createDeadLink) {
        this._createDeadLink = createDeadLink;
    }

    public TnRelationSelector getRelationSelector() {
        return this._relSelector;
    }

    public void setRelationSelector(TnRelationSelector relSelector) {
        this._relSelector = relSelector;
    }
}

