/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.s2dao.valuetype.basic.ObjectType;

public class TnPlainValueTypes {
    protected final Map<Class<?>, ValueType> _basicObjectValueTypeMap = new ConcurrentHashMap();
    protected final Map<Class<?>, ValueType> _basicInterfaceValueTypeMap = new ConcurrentHashMap();
    protected final Map<String, ValueType> _pluginValueTypeMap = new ConcurrentHashMap<String, ValueType>();
    protected final Map<Integer, ValueType> _dynamicObjectValueTypeMap = new ConcurrentHashMap<Integer, ValueType>();

    public TnPlainValueTypes() {
        this.initialize();
    }

    protected void initialize() {
        this.registerBasicValueType(String.class, TnValueTypes.STRING);
        this.registerBasicValueType(Character.TYPE, TnValueTypes.CHARACTER);
        this.registerBasicValueType(Character.class, TnValueTypes.CHARACTER);
        this.registerBasicValueType(Byte.TYPE, TnValueTypes.BYTE);
        this.registerBasicValueType(Byte.class, TnValueTypes.BYTE);
        this.registerBasicValueType(Short.TYPE, TnValueTypes.SHORT);
        this.registerBasicValueType(Short.class, TnValueTypes.SHORT);
        this.registerBasicValueType(Integer.TYPE, TnValueTypes.INTEGER);
        this.registerBasicValueType(Integer.class, TnValueTypes.INTEGER);
        this.registerBasicValueType(Long.TYPE, TnValueTypes.LONG);
        this.registerBasicValueType(Long.class, TnValueTypes.LONG);
        this.registerBasicValueType(Float.TYPE, TnValueTypes.FLOAT);
        this.registerBasicValueType(Float.class, TnValueTypes.FLOAT);
        this.registerBasicValueType(Double.TYPE, TnValueTypes.DOUBLE);
        this.registerBasicValueType(Double.class, TnValueTypes.DOUBLE);
        this.registerBasicValueType(BigInteger.class, TnValueTypes.BIGINTEGER);
        this.registerBasicValueType(BigDecimal.class, TnValueTypes.BIGDECIMAL);
        this.registerBasicValueType(Date.class, TnValueTypes.SQLDATE);
        this.registerBasicValueType(Time.class, TnValueTypes.TIME);
        this.registerBasicValueType(java.util.Date.class, TnValueTypes.UTILDATE_AS_SQLDATE);
        this.registerBasicValueType(Timestamp.class, TnValueTypes.TIMESTAMP);
        this.registerBasicValueType(Calendar.class, TnValueTypes.TIMESTAMP);
        this.registerBasicValueType(TnValueTypes.BYTE_ARRAY_CLASS, TnValueTypes.BINARY);
        this.registerBasicValueType(InputStream.class, TnValueTypes.BINARY_STREAM);
        this.registerBasicValueType(Boolean.TYPE, TnValueTypes.BOOLEAN);
        this.registerBasicValueType(Boolean.class, TnValueTypes.BOOLEAN);
        this.registerBasicValueType(UUID.class, TnValueTypes.UUID_AS_DIRECT);
        this.registerBasicValueType(Classification.class, TnValueTypes.CLASSIFICATION);
        this.registerPluginValueType("stringClobType", TnValueTypes.STRING_CLOB);
        this.registerPluginValueType("bytesOidType", TnValueTypes.BYTES_OID);
        this.registerPluginValueType("fixedLengthStringType", TnValueTypes.FIXED_LENGTH_STRING);
        this.registerPluginValueType("objectBindingBigDecimalType", TnValueTypes.OBJECT_BINDING_BIGDECIMAL);
        this.registerPluginValueType("oracleDateType", TnValueTypes.UTILDATE_AS_TIMESTAMP);
        this.registerPluginValueType("uuidAsStringType", TnValueTypes.UUID_AS_STRING);
    }

    public ValueType findByTypeOrValue(Class<?> type, Object value) {
        ValueType byType = this.getValueType(type);
        if (!this.isDefaultObject(byType)) {
            return byType;
        }
        return this.getValueType(value);
    }

    public ValueType findByValueOrJdbcDefType(Object value, int jdbcDefType) {
        ValueType byValue = this.getValueType(value);
        if (!this.isDefaultObject(byValue)) {
            return byValue;
        }
        return this.getValueType(jdbcDefType);
    }

    public ValueType getValueType(Object value) {
        if (value == null) {
            return TnValueTypes.DEFAULT_OBJECT;
        }
        return this.getValueType(value.getClass());
    }

    public ValueType getValueType(Class<?> type) {
        if (type == null) {
            return TnValueTypes.DEFAULT_OBJECT;
        }
        boolean interfaceFirst = Enum.class.isAssignableFrom(type);
        ValueType valueType = null;
        if (interfaceFirst) {
            valueType = this.getBasicInterfaceValueType(type);
            if (valueType == null) {
                valueType = this.getBasicObjectValueType(type);
            }
        } else {
            valueType = this.getBasicObjectValueType(type);
            if (valueType == null) {
                valueType = this.getBasicInterfaceValueType(type);
            }
        }
        return valueType != null ? valueType : TnValueTypes.DEFAULT_OBJECT;
    }

    protected ValueType getBasicObjectValueType(Class<?> type) {
        for (Class<?> c = type; c != null && c != Object.class; c = c.getSuperclass()) {
            ValueType valueType = this._basicObjectValueTypeMap.get(c);
            if (valueType == null) continue;
            return valueType;
        }
        return null;
    }

    protected ValueType getBasicInterfaceValueType(Class<?> type) {
        Set<Map.Entry<Class<?>, ValueType>> entrySet = this._basicInterfaceValueTypeMap.entrySet();
        for (Map.Entry<Class<?>, ValueType> entry : entrySet) {
            Class<?> inf = entry.getKey();
            if (!inf.isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType getValueType(int jdbcDefType) {
        Class<?> type = this.getType(jdbcDefType);
        if (type.equals(Object.class)) {
            ValueType valueType = this._dynamicObjectValueTypeMap.get(jdbcDefType);
            if (valueType != null) {
                return valueType;
            }
            TnPlainValueTypes tnPlainValueTypes = this;
            synchronized (tnPlainValueTypes) {
                valueType = this._dynamicObjectValueTypeMap.get(jdbcDefType);
                if (valueType != null) {
                    return valueType;
                }
                ObjectType objectType = new ObjectType(jdbcDefType);
                this._dynamicObjectValueTypeMap.put(jdbcDefType, objectType);
                return objectType;
            }
        }
        return this.getValueType(type);
    }

    protected Class<?> getType(int jdbcDefType) {
        switch (jdbcDefType) {
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TnValueTypes.BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public ValueType getPluginValueType(String valueTypeName) {
        this.assertObjectNotNull("valueTypeName", valueTypeName);
        return this._pluginValueTypeMap.get(valueTypeName);
    }

    public boolean isDefaultObject(ValueType valueType) {
        if (valueType == null) {
            return false;
        }
        if (!ObjectType.class.equals(valueType.getClass())) {
            return false;
        }
        return ((ObjectType)valueType).isDefaultObject();
    }

    public boolean isDynamicObject(ValueType valueType) {
        if (valueType == null) {
            return false;
        }
        if (!ObjectType.class.equals(valueType.getClass())) {
            return false;
        }
        return !((ObjectType)valueType).isDefaultObject();
    }

    public synchronized void registerBasicValueType(Class<?> keyType, ValueType valueType) {
        this.assertObjectNotNull("keyType", keyType);
        this.assertObjectNotNull("valueType", valueType);
        if (keyType.isInterface()) {
            this._basicInterfaceValueTypeMap.put(keyType, valueType);
        } else {
            this._basicObjectValueTypeMap.put(keyType, valueType);
        }
    }

    public synchronized void removeBasicValueType(Class<?> keyType) {
        this.assertObjectNotNull("keyType", keyType);
        if (this._basicObjectValueTypeMap.containsKey(keyType)) {
            this._basicObjectValueTypeMap.remove(keyType);
        }
        if (this._basicInterfaceValueTypeMap.containsKey(keyType)) {
            this._basicInterfaceValueTypeMap.remove(keyType);
        }
    }

    public synchronized void registerPluginValueType(String keyName, ValueType valueType) {
        this.assertObjectNotNull("keyName", keyName);
        this.assertObjectNotNull("valueType", valueType);
        this._pluginValueTypeMap.put(keyName, valueType);
    }

    public synchronized void removePluginValueType(String keyName) {
        this.assertObjectNotNull("keyName", keyName);
        this._pluginValueTypeMap.remove(keyName);
    }

    protected synchronized void restoreDefault() {
        this._basicObjectValueTypeMap.clear();
        this._basicInterfaceValueTypeMap.clear();
        this._pluginValueTypeMap.clear();
        this._dynamicObjectValueTypeMap.clear();
        this.initialize();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

