/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public class TextSampleEntry
extends AbstractSampleEntry {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private long displayFlags;
    private int horizontalJustification;
    private int verticalJustification;
    private int[] backgroundColorRgba = new int[4];
    private BoxRecord boxRecord = new BoxRecord();
    private StyleRecord styleRecord = new StyleRecord();

    public TextSampleEntry() {
        super(TYPE1);
    }

    public TextSampleEntry(String type) {
        super(type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer content = ByteBuffer.allocate(38);
        dataSource.read(content);
        content.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(content);
        this.displayFlags = IsoTypeReader.readUInt32(content);
        this.horizontalJustification = IsoTypeReader.readUInt8(content);
        this.verticalJustification = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba = new int[4];
        this.backgroundColorRgba[0] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[1] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[2] = IsoTypeReader.readUInt8(content);
        this.backgroundColorRgba[3] = IsoTypeReader.readUInt8(content);
        this.boxRecord = new BoxRecord();
        this.boxRecord.parse(content);
        this.styleRecord = new StyleRecord();
        this.styleRecord.parse(content);
        this.parseContainer(dataSource, contentSize - 38L, boxParser);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(38);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeUInt32(byteBuffer, this.displayFlags);
        IsoTypeWriter.writeUInt8(byteBuffer, this.horizontalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.verticalJustification);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[0]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[1]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[2]);
        IsoTypeWriter.writeUInt8(byteBuffer, this.backgroundColorRgba[3]);
        this.boxRecord.getContent(byteBuffer);
        this.styleRecord.getContent(byteBuffer);
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    public String toString() {
        return "TextSampleEntry";
    }

    public BoxRecord getBoxRecord() {
        return this.boxRecord;
    }

    public void setBoxRecord(BoxRecord boxRecord) {
        this.boxRecord = boxRecord;
    }

    public StyleRecord getStyleRecord() {
        return this.styleRecord;
    }

    public void setStyleRecord(StyleRecord styleRecord) {
        this.styleRecord = styleRecord;
    }

    public boolean isScrollIn() {
        return (this.displayFlags & 0x20L) == 32L;
    }

    public void setScrollIn(boolean scrollIn) {
        this.displayFlags = scrollIn ? (this.displayFlags |= 0x20L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean isScrollOut() {
        return (this.displayFlags & 0x40L) == 64L;
    }

    public void setScrollOut(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x40L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFBFL);
    }

    public boolean isScrollDirection() {
        return (this.displayFlags & 0x180L) == 384L;
    }

    public void setScrollDirection(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x180L) : (this.displayFlags &= 0xFFFFFFFFFFFFFE7FL);
    }

    public boolean isContinuousKaraoke() {
        return (this.displayFlags & 0x800L) == 2048L;
    }

    public void setContinuousKaraoke(boolean continuousKaraoke) {
        this.displayFlags = continuousKaraoke ? (this.displayFlags |= 0x800L) : (this.displayFlags &= 0xFFFFFFFFFFFFF7FFL);
    }

    public boolean isWriteTextVertically() {
        return (this.displayFlags & 0x20000L) == 131072L;
    }

    public void setWriteTextVertically(boolean writeTextVertically) {
        this.displayFlags = writeTextVertically ? (this.displayFlags |= 0x20000L) : (this.displayFlags &= 0xFFFFFFFFFFFDFFFFL);
    }

    public boolean isFillTextRegion() {
        return (this.displayFlags & 0x40000L) == 262144L;
    }

    public void setFillTextRegion(boolean fillTextRegion) {
        this.displayFlags = fillTextRegion ? (this.displayFlags |= 0x40000L) : (this.displayFlags &= 0xFFFFFFFFFFFBFFFFL);
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setHorizontalJustification(int horizontalJustification) {
        this.horizontalJustification = horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setVerticalJustification(int verticalJustification) {
        this.verticalJustification = verticalJustification;
    }

    public int[] getBackgroundColorRgba() {
        return this.backgroundColorRgba;
    }

    public void setBackgroundColorRgba(int[] backgroundColorRgba) {
        this.backgroundColorRgba = backgroundColorRgba;
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 38L;
        return s + t + (long)(this.largeBox || s + t >= 0x100000000L ? 16 : 8);
    }

    public static class BoxRecord {
        int top;
        int left;
        int bottom;
        int right;

        public BoxRecord() {
        }

        public BoxRecord(int top, int left, int bottom, int right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public void parse(ByteBuffer in) {
            this.top = IsoTypeReader.readUInt16(in);
            this.left = IsoTypeReader.readUInt16(in);
            this.bottom = IsoTypeReader.readUInt16(in);
            this.right = IsoTypeReader.readUInt16(in);
        }

        public void getContent(ByteBuffer bb) {
            IsoTypeWriter.writeUInt16(bb, this.top);
            IsoTypeWriter.writeUInt16(bb, this.left);
            IsoTypeWriter.writeUInt16(bb, this.bottom);
            IsoTypeWriter.writeUInt16(bb, this.right);
        }

        public int getSize() {
            return 8;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoxRecord boxRecord = (BoxRecord)o;
            if (this.bottom != boxRecord.bottom) {
                return false;
            }
            if (this.left != boxRecord.left) {
                return false;
            }
            if (this.right != boxRecord.right) {
                return false;
            }
            return this.top == boxRecord.top;
        }

        public int hashCode() {
            int result = this.top;
            result = 31 * result + this.left;
            result = 31 * result + this.bottom;
            result = 31 * result + this.right;
            return result;
        }
    }

    public static class StyleRecord {
        int startChar;
        int endChar;
        int fontId;
        int faceStyleFlags;
        int fontSize;
        int[] textColor = new int[]{255, 255, 255, 255};

        public StyleRecord() {
        }

        public StyleRecord(int startChar, int endChar, int fontId, int faceStyleFlags, int fontSize, int[] textColor) {
            this.startChar = startChar;
            this.endChar = endChar;
            this.fontId = fontId;
            this.faceStyleFlags = faceStyleFlags;
            this.fontSize = fontSize;
            this.textColor = textColor;
        }

        public void parse(ByteBuffer in) {
            this.startChar = IsoTypeReader.readUInt16(in);
            this.endChar = IsoTypeReader.readUInt16(in);
            this.fontId = IsoTypeReader.readUInt16(in);
            this.faceStyleFlags = IsoTypeReader.readUInt8(in);
            this.fontSize = IsoTypeReader.readUInt8(in);
            this.textColor = new int[4];
            this.textColor[0] = IsoTypeReader.readUInt8(in);
            this.textColor[1] = IsoTypeReader.readUInt8(in);
            this.textColor[2] = IsoTypeReader.readUInt8(in);
            this.textColor[3] = IsoTypeReader.readUInt8(in);
        }

        public void getContent(ByteBuffer bb) {
            IsoTypeWriter.writeUInt16(bb, this.startChar);
            IsoTypeWriter.writeUInt16(bb, this.endChar);
            IsoTypeWriter.writeUInt16(bb, this.fontId);
            IsoTypeWriter.writeUInt8(bb, this.faceStyleFlags);
            IsoTypeWriter.writeUInt8(bb, this.fontSize);
            IsoTypeWriter.writeUInt8(bb, this.textColor[0]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[1]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[2]);
            IsoTypeWriter.writeUInt8(bb, this.textColor[3]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyleRecord that = (StyleRecord)o;
            if (this.endChar != that.endChar) {
                return false;
            }
            if (this.faceStyleFlags != that.faceStyleFlags) {
                return false;
            }
            if (this.fontId != that.fontId) {
                return false;
            }
            if (this.fontSize != that.fontSize) {
                return false;
            }
            if (this.startChar != that.startChar) {
                return false;
            }
            return Arrays.equals(this.textColor, that.textColor);
        }

        public int hashCode() {
            int result = this.startChar;
            result = 31 * result + this.endChar;
            result = 31 * result + this.fontId;
            result = 31 * result + this.faceStyleFlags;
            result = 31 * result + this.fontSize;
            result = 31 * result + (this.textColor != null ? Arrays.hashCode(this.textColor) : 0);
            return result;
        }

        public int getSize() {
            return 12;
        }
    }
}

