/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SchemeTypeBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.MemoryDataSourceImpl;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Mp4TrackImpl;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.cenc.CencSampleAuxiliaryDataFormat;
import com.googlecode.mp4parser.util.Path;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeCencTrack
extends AbstractTrack {
    DecryptedSampleList samples;
    Track original;

    public DeCencTrack(Mp4TrackImpl original, SecretKey key) {
        this.original = original;
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath(original.getSampleDescriptionBox(), "enc./sinf/schm");
        if (!"cenc".equals(schm.getSchemeType())) {
            throw new RuntimeException("You can only use the DeCencTrack with CENC encrypted tracks");
        }
        this.samples = new DecryptedSampleList(key, original.getSamples(), original, original.getSampleEncryptionEntries());
    }

    @Override
    public long[] getSyncSamples() {
        return this.original.getSyncSamples();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox stsd;
        OriginalFormatBox frma = (OriginalFormatBox)Path.getPath(this.original.getSampleDescriptionBox(), "enc./sinf/frma");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.original.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
            stsd = (SampleDescriptionBox)new IsoFile(new MemoryDataSourceImpl(baos.toByteArray())).getBoxes().get(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Dumping stsd to memory failed");
        }
        if (stsd.getSampleEntry() instanceof AudioSampleEntry) {
            ((AudioSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else if (stsd.getSampleEntry() instanceof VisualSampleEntry) {
            ((VisualSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else {
            throw new RuntimeException("I don't know " + stsd.getSampleEntry().getType());
        }
        LinkedList<Box> nuBoxes = new LinkedList<Box>();
        for (Box box : stsd.getSampleEntry().getBoxes()) {
            if (box.getType().equals("sinf")) continue;
            nuBoxes.add(box);
        }
        stsd.getSampleEntry().setBoxes(nuBoxes);
        return stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.original.getSampleDurations();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.original.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.original.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.original.getMediaHeaderBox();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecryptedSampleList
    extends AbstractList<Sample> {
        List<CencSampleAuxiliaryDataFormat> sencInfo;
        AvcConfigurationBox avcC = null;
        SecretKey secretKey;
        List<Sample> parent;

        public DecryptedSampleList(SecretKey secretKey, List<Sample> parent, Track track, List<CencSampleAuxiliaryDataFormat> sencInfo) {
            this.sencInfo = sencInfo;
            this.secretKey = secretKey;
            this.parent = parent;
            List<Box> boxes = track.getSampleDescriptionBox().getSampleEntry().getBoxes();
            for (Box box : boxes) {
                if (!(box instanceof AvcConfigurationBox)) continue;
                this.avcC = (AvcConfigurationBox)box;
            }
        }

        Cipher getCipher(SecretKey sk, byte[] iv) {
            byte[] fullIv = new byte[16];
            System.arraycopy(iv, 0, fullIv, 0, iv.length);
            try {
                Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
                cipher.init(2, (Key)sk, new IvParameterSpec(fullIv));
                return cipher;
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Sample get(int index) {
            Sample encSample = this.parent.get(index);
            ByteBuffer encSampleBuffer = encSample.asByteBuffer();
            encSampleBuffer.rewind();
            ByteBuffer decSampleBuffer = ByteBuffer.allocate(encSampleBuffer.limit());
            CencSampleAuxiliaryDataFormat sencEntry = this.sencInfo.get(index);
            Cipher cipher = this.getCipher(this.secretKey, sencEntry.iv);
            try {
                if (this.avcC != null) {
                    List<CencSampleAuxiliaryDataFormat.Pair> pairs = sencEntry.pairs;
                    for (CencSampleAuxiliaryDataFormat.Pair pair : pairs) {
                        int clearBytes = pair.clear;
                        int encrypted = (int)pair.encrypted;
                        byte[] clears = new byte[clearBytes];
                        encSampleBuffer.get(clears);
                        decSampleBuffer.put(clears);
                        if (encrypted <= 0) continue;
                        byte[] encs = new byte[encrypted];
                        encSampleBuffer.get(encs);
                        byte[] decr = cipher.update(encs);
                        decSampleBuffer.put(decr);
                    }
                    if (encSampleBuffer.remaining() > 0) {
                        System.err.println("Decrypted sample but still data remaining: " + encSample.getSize());
                    }
                    decSampleBuffer.put(cipher.doFinal());
                } else {
                    byte[] fullyEncryptedSample = new byte[encSampleBuffer.limit()];
                    encSampleBuffer.get(fullyEncryptedSample);
                    decSampleBuffer.put(cipher.doFinal(fullyEncryptedSample));
                }
                encSampleBuffer.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
            decSampleBuffer.rewind();
            return new SampleImpl(decSampleBuffer);
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }
}

