/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.purehtml;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.AbstractResponse;
import com.small_it_office.flatserve.purehtml.CannotLoadHtmlException;
import com.small_it_office.flatserve.purehtml.PureHtmlConfig;
import com.small_it_office.flatserve.purehtml.internal.document.HtmlDocumentProcessor;
import com.small_it_office.shared.meslog.message.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.htmlparser.jericho.Source;

public class PureHtmlResponse
extends AbstractResponse {
    private String encoding = null;
    private Map<String, Object> responseValues = new HashMap<String, Object>();
    private String htmlFilePath;
    private Source source;
    private HtmlDocumentProcessor documentProcessor = new HtmlDocumentProcessor();

    public PureHtmlResponse(String htmlFilePath) {
        if (htmlFilePath == null) {
            throw new IllegalArgumentException(Message.get((String)"FSPHT-ERR004", (Object[])new Object[0]));
        }
        this.htmlFilePath = htmlFilePath;
    }

    protected String getContentType() {
        if (this.source.isXML()) {
            return "application/xhtml+xml";
        }
        return "text/html";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException(Message.get((String)"FSPHT-ERR005", (Object[])new Object[]{encoding}));
        }
        this.encoding = encoding;
    }

    public void putValue(String idOrName, Object value) {
        if (idOrName == null) {
            throw new IllegalArgumentException(Message.get((String)"FSPHT-ERR006", (Object[])new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(Message.get((String)"FSPHT-ERR007", (Object[])new Object[0]));
        }
        this.responseValues.put(idOrName, value);
    }

    public void loadSource(RequestContext context, PureHtmlConfig config) {
        String webInfPath = this.htmlFilePath.startsWith("/") ? "/WEB-INF" + this.htmlFilePath : "/WEB-INF/" + this.htmlFilePath;
        InputStream stream = context.getServletConfig().getServletContext().getResourceAsStream(webInfPath);
        if (stream == null && config.isAvailableClasspathForHtmlSource()) {
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.htmlFilePath);
        }
        if (stream == null) {
            throw new CannotLoadHtmlException(Message.get((String)"FSPHT-ERR002", (Object[])new Object[]{this.htmlFilePath}));
        }
        if (this.encoding != null) {
            InputStreamReader reader;
            try {
                reader = new InputStreamReader(stream, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedException((Throwable)e);
            }
            try {
                this.source = new Source((Reader)reader);
            }
            catch (IOException e) {
                throw new CannotLoadHtmlException(Message.get((String)"FSPHT-ERR003", (Object[])new Object[]{this.htmlFilePath}), e);
            }
        }
        try {
            this.source = new Source(stream);
        }
        catch (IOException e) {
            throw new CannotLoadHtmlException(Message.get((String)"FSPHT-ERR003", (Object[])new Object[]{this.htmlFilePath}), e);
        }
    }

    protected void writeResponse(RequestContext context) throws IOException {
        String html = this.documentProcessor.process(this.source, this.responseValues);
        HttpServletResponse response = context.getHttpServletResponse();
        if (this.encoding != null) {
            response.setCharacterEncoding(this.encoding);
        } else {
            response.setCharacterEncoding(this.source.getEncoding());
        }
        PrintWriter out = response.getWriter();
        out.write(html);
    }
}

