/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.purehtml.internal.document;

import com.small_it_office.flatserve.purehtml.internal.document.HtmlTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.ModifierUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputTagByNameValueModifier
implements HtmlTagValueModifier {
    @Override
    public boolean modifyDocument(OutputDocument outputDocument, List<Element> elementsByName, Object responseValue) {
        boolean modified = false;
        Element elementByName = elementsByName.get(0);
        String type = elementByName.getAttributeValue("type");
        if (type != null) {
            if (ModifierUtil.matchesAny(type.toLowerCase(), "text", "hidden")) {
                String attributeName = "value";
                String newTagText = ModifierUtil.insertAttributeValue(elementByName, attributeName, responseValue);
                if (newTagText != null) {
                    outputDocument.replace((Segment)elementByName, (CharSequence)newTagText);
                    modified = true;
                }
            } else if ("checkbox".equalsIgnoreCase(type)) {
                boolean checked = responseValue instanceof Boolean ? ((Boolean)responseValue).booleanValue() : responseValue.toString().equals(elementByName.getAttributeValue("value"));
                Attributes attributes = elementByName.getAttributes();
                LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
                attributes.populateMap(attributesMap, false);
                String checkedKey = "checked";
                Set attributeKeys = attributesMap.keySet();
                for (String attributeKey : attributeKeys) {
                    if (!attributeKey.equalsIgnoreCase("checked")) continue;
                    checkedKey = attributeKey;
                    break;
                }
                if (checked) {
                    if (!"checked".equalsIgnoreCase((String)attributesMap.get(checkedKey))) {
                        attributesMap.put(checkedKey, "checked");
                        modified = true;
                    }
                } else if (attributesMap.containsKey(checkedKey)) {
                    attributesMap.remove(checkedKey);
                    modified = true;
                }
                if (modified) {
                    outputDocument.replace(attributes, attributesMap);
                }
            } else if ("radio".equalsIgnoreCase(type)) {
                for (Element radioElement : elementsByName) {
                    if (!"radio".equalsIgnoreCase(type)) continue;
                    Attributes attributes = radioElement.getAttributes();
                    LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
                    attributes.populateMap(attributesMap, false);
                    String checkedKey = "checked";
                    Set attributeKeys = attributesMap.keySet();
                    for (String attributeKey : attributeKeys) {
                        if (!attributeKey.equalsIgnoreCase("checked")) continue;
                        checkedKey = attributeKey;
                        break;
                    }
                    if (responseValue.toString().equals(attributesMap.get("value"))) {
                        if (!"checked".equalsIgnoreCase((String)attributesMap.get(checkedKey))) {
                            attributesMap.put(checkedKey, "checked");
                            modified = true;
                        }
                    } else if (attributesMap.containsKey(checkedKey)) {
                        attributesMap.remove(checkedKey);
                        modified = true;
                    }
                    if (!modified) continue;
                    outputDocument.replace(attributes, attributesMap);
                }
            }
        }
        return modified;
    }

    @Override
    public boolean responsible(String elementName) {
        return "input".equals(elementName);
    }
}

