<?php
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR."ModuleBase.class.php");
/**
 * spider：POSTおよびGETで入力されたパラメータの文字コードを全てUTF-8に変換する
 * アクションモジュールクラス
 * 
 * @package spider spider/moduleパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_module_AutoEncode extends spider_ModuleBase {
	function spider_module_AutoEncode() {
	}
	function execute( & $request ) {
		$vars			= $_POST;
		$strings		= print_r($vars,true);
		$vars			= $_GET;
		$strings		.= print_r($vars,true);
		$vars			= null;
		$inputCharset	= mb_detect_encoding($strings,'auto');
		if( $inputCharset != 'UTF-8' ) {
			// POSTパラメータ
			$this->encodeHash( $_POST,'UTF-8', $inputCharset );
			// GETパラメータ
			$this->encodeHash( $_GET,'UTF-8', $inputCharset );
		}
		$request->setAttribute( 'postparams', $_POST );
		$request->setAttribute( 'getparams', $_GET );
	}
	/**
	 * 多次元配列を指定文字セットにエンコードします
	 */
	function encodeHash( & $hash,$toChar='UTF-8', $fromChar ) {
		if( is_array($hash) ) {
			foreach( $hash as $key => $val ) {
				$encKey	= mb_convert_encoding( $key, $toChar, $fromChar );
				if( is_array($val) ) {
					$this->encodeHash( $hash[$key],$toChar,$fromChar );
					$hash[$encKey]	= $hash[$key];
				} else {
					$val			= mb_convert_encoding( $val, $toChar, $fromChar );
					$hash[$key]		= $val;
					$hash[$encKey]	= $val;
				}
			}
		}
	}
}
?>