<?php
/**
 * HTML用変換タグ：use-sessionタグクラス
 * 
 * {use-session:[true/false]}
 * 対象ページでPHPのセッション機能を利用するか否かを設定するタグです。
 * falseの場合sessionがスタートされません。
 * デフォルトはtrueです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_UseSession extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_UseSession() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		if( preg_match('/\\{use\\-session\\:[fF][aA][lL][sS][eE]\\}/', $result_strings ) > 0
			|| preg_match('/\\{use\\-session\\:[nN][oO]\\}/', $result_strings ) > 0 ) {
			// falseかnoが指定されているならセッションは開始しない
			$result_strings = preg_replace( '/\\{use\\-session\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $result_strings );
		} else {
			// 明示的にセッション開始を否定していないなら暗黙的にセッションを開始する
			$result_strings = preg_replace( '/\\{use\\-session\\:[^\\}]*?\\}/'
				, "", $result_strings );
			$process_code	= "if( defined('SPIDER_USE_SPIDER_SESSION_ID') && SPIDER_USE_SPIDER_SESSION_ID ) {\n"
				. "if( !spider_session_start() ) {\n"
				. "header( 'Content-type: text/plain;charset=UTF-8' );\n"
				. "die( '".$GLOBALS['spider.messages']['spider.tags.usesession.cantstart']."' );\n}\n"
				. "}else{\n"
				. "session_start();\n}"
				. "\n"
				. '$GLOBALS[\'request_object\']->setAttribute( \'spider.session_name\', session_name(), SPIDER_SESSION_SCOPE_GLOBAL );'. "\n"
				. '$GLOBALS[\'request_object\']->setAttribute( \'spider.session_id\', session_id(), SPIDER_SESSION_SCOPE_GLOBAL );'. "\n"
			;
			if( !isset($build_information->preview_process_hash)
				|| !is_array($build_information->preview_process_hash) ){
				$build_information->preview_process_hash	= array();
			}
			if( !isset($build_information->preview_process_hash[$this->priority])
				|| !is_array($build_information->preview_process_hash[$this->priority]) ){
				$build_information->preview_process_hash[$this->priority]	= array();
			}
			array_push( $build_information->preview_process_hash[$this->priority], $process_code );
		}
	}
}
?>