<?php
/**
 * ファイルシステムに関するユーティリティ関数群を提供する静的メソッドクラス
 */
class util_File {
	/**
	 * 指定フォルダ以下のフォルダとファイルを指定フォルダ化にコピーします
	 * @param $resource_dir コピー元フォルダパス
	 * @param $destination_dir コピー先フォルダパス
	 */
	function copyDirFiles( $resource_dir, $destination_dir, $force=false ) {
		if( is_dir( $resource_dir ) && is_dir($destination_dir) ) {
			if ($dh = opendir($resource_dir)) {
				while (($file_name = readdir($dh)) !== false) {
					if( preg_match('/^\\./',$file_name) == 0 ) {
						$file_absolute_path	= $resource_dir.DIRECTORY_SEPARATOR.$file_name;
						$file_type			= filetype($file_absolute_path);
						$destination_path	= $destination_dir.DIRECTORY_SEPARATOR.$file_name;
						if( preg_match('/^[dD][iI][rR]/', filetype($file_absolute_path) ) ) {
							// フォルダの場合なければ作成する
							if( !file_exists($destination_path) ) {
								if( @mkdir( $destination_path, SPIDER_FOLDER_CREATE_PERMITTION ) ) {
									@chmod( $destination_path, SPIDER_FOLDER_CREATE_PERMITTION );
								} else {
									return false;
								}
							}
							// 再帰呼び出し
							if( !util_File::copyDirFiles( $file_absolute_path, $destination_path ) ) {
								return false;
							}
						} else if( preg_match('/^[fF][iI][lL][eE]/', filetype($file_absolute_path) ) ) {
							// 対象がファイルの場合なければコピー
							if( $force || !file_exists($destination_path) ) {
								if( @copy( $file_absolute_path, $destination_path ) ) {
									@chmod( $destination_path, SPIDER_FOLDER_CREATE_PERMITTION );
								} else {
									return false;
								}
							}
						}
					}
				}
				@closedir( $dh );
			}
		} else {
			return false;
		}
		return true;
	}
	/**
	 * spiderアプリケーション内の絶対ファイルパスをアプリケーションURIに変換します
	 */
	function path2suri( $absolutePath ) {
		$basePath		= str_replace(DIRECTORY_SEPARATOR,'/',APPLICATION_BASE_PATH);
		$absolutePath	= str_replace(DIRECTORY_SEPARATOR,'/',$absolutePath);
		if( strlen($absolutePath) >= strlen($basePath) ) {
			$retUri		= str_replace($basePath,'',$absolutePath);
			if( preg_match('/\\/$/',$retUri) > 0 ) { $retUri	= preg_replace('/\\/$/','',$retUri); }
			if( preg_match('/^\\//',$retUri) == 0 ) { $retUri	= '/'.$retUri; }
			return $retUri;
		}
		return false;
	}
	/**
	 * spiderアプリケーション内のURIからファイル絶対パスに変換します
	 */
	function suri2path( $uri ) {
		$absolutePath	= str_replace(DIRECTORY_SEPARATOR,'/',APPLICATION_BASE_PATH);
		if( preg_match('/\\/$/',$absolutePath) > 0 ) {
			$absolutePath	= preg_replace('/\\/$/','',$absolutePath);
		}
		if( '/' == $uri ) {
		} else {
			$absolutePath	.= $uri;
		}
		$absolutePath	= str_replace('/',DIRECTORY_SEPARATOR,$absolutePath);
		return $absolutePath;
	}
}
?>