<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_formal_white', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   theme_formal_white
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['blockcolumnwidth'] = 'Blocks column width';
$string['blockcolumnwidthdesc'] = 'This sets the blocks column width for the theme. <strong>Using widths lower than 200px, the calendar block is not supposed to fit.</strong>';
$string['blockcontentbgc'] = 'Blocks content background colour';
$string['blockcontentbgcdesc'] = 'This sets the blocks content background colour for the theme.';
$string['choosereadme'] = '
<div class="clearfix">
    <div class="theme_screenshot">
        <h2>Formal White</h2>
        <img src="formal_white/pix/screenshot.gif" />

        <h3>Theme Discussion Forum:</h3>
        <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

        <h3>Theme Credits</h3>
        <p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

        <h3>Theme Documentation:</h3>
        <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

        <h3>Report a bug:</h3>
        <p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
    </div>
    <div class="theme_description">
        <h2>About</h2>
        <p>Formal White is a fluid-width, three-column theme ported over to 2.0 from Moodle 1.X.</p>
        <h2>Tweaks</h2>
        <p>This theme is built upon both Base and Canvas, two parent themes included in the Moodle core. If you want to modify this theme, we recommend that you first duplicate it, then rename it before making your changes. This will prevent your customized theme from being overwritten by future Moodle upgrades, and you\'ll still have the original files if you make a mess. More information on modifying themes can be found in the <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a>.</p>
    <h2>Credits</h2>
    <p>This theme was coded and is maintained by MediaTouch 2000. </p>
        <h2>License</h2>
        <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
    </div>
</div>';
$string['configtitle'] = 'Formal white theme';
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Any CSS you enter here will be added to every page allowing your to easily customise this theme.';
$string['displaylogo'] = 'Pages header content';
$string['displaylogodesc'] = 'Choose whether display moodle logo or page heading text in the header.';
$string['fontsizereference'] = 'Font size reference';
$string['fontsizereferencedesc'] = 'This allows you to set the default font size for this theme. It is not recommended to set this higher than 13px as it is known to cause display problems with certain blocks.';
$string['footnote'] = 'Footnote';
$string['footnotedesc'] = 'The content from this textarea will be displayed in the footer of every page.';
$string['headerbgc'] = 'Header background colour';
$string['headerbgcdesc'] = 'This sets the blocks header background colour for the theme.';
$string['heading'] = 'Display page heading';
$string['lblockcolumnbgc'] = 'Left column background colour';
$string['lblockcolumnbgcdesc'] = 'This sets the left column background colour for the theme.';
$string['logo'] = 'logo';
$string['logodesc'] = 'Change the logo of this theme by entering the URL to a new one (i.e., http://www.somesite/animage.png). As a reference, the default logo is 300px wide by 80px high. A transparent .png will work best.<br />The chosen logo will be shown in each page of the site without any distinction between front page and other pages.';
$string['moodlelogo'] = 'Display moodle logo';
$string['noframe'] = 'Formal white 1.9 look';
$string['noframedesc'] = 'Select this option to require your moodle page to look like moodle 1.*, alias, without the surrounding frame.';
$string['pluginname'] = 'Formal white';
$string['rblockcolumnbgc'] = 'Right column background colour';
$string['rblockcolumnbgcdesc'] = 'This sets the right column background colour for the theme. If you leave this empty the left column background color will be used.';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';