<?php  /// Moodle Configuration File 
// Moodle2.0から導入されたOutput Redererの互換のための関数群
// および，fs_status.php以下で使用されるオリジナルのHTML出力の関数群
// fs_lib.phpでrequireされる前提


// -------------------------------------------------------------------

// 単なる改行
function newline($display = true)
{
    if ($display) echo '<br />';
    return '<br />';
}

// fs_status中のページ遷移専用のリンク生成
function print_link2page($page = '')
{
    global $CFG;
    newline();
    if (!empty($page)) $page = '?page='.$page;
    echo '<center><a href="'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/index.php'.$page.'">＜戻る＞</a></center>';
}

// 比較的汎用なリンク生成
function fs_linktext($url, $newwindow = false, $message = null)
{
    if (empty($message)) $message = $url;
    $target = '';
    if ($newwindow) $target = ' target = "_blank"';
    return '<a href = "'.$url.'"'.$target.'>'.$message.'</a>';
}

// その表示
function fs_print_linktext($url, $newwindow = false, $message = nul)
{
    echo fs_linktext($url, $newwindow, $message);
}

// 警告メッセージの表示用関数
function print_notice_message($title, $str)
{
    echo '<div style="padding-top:10px; padding-bottom:10px;">';
    echo '<div style="padding-left:10px; padding-top:5px; padding-bottom:5px;background-color:#fcd0d0;">';
    echo color_red('['.$title.']：&nbsp;');
    echo $str;
    echo '</div>';
    echo '</div>';
}

// --------------------------------
// 論理的なブロック
// セクションの開始
function print_section_header($string, $additional = null)
{
    global $titleonly, $output;
    if (!empty($titleonly)) {
        while(@ob_get_clean());
        ob_start();
    }
    echo '<div>';
    echo '<table width="100%" cellpadding="5" cellspacing="1" bgcolor="#F8FCFC"class="environmenttable generaltable boxaligncenter" >';
    echo '<tr>';
    echo '<th class="header c0">'.$string;
    if ($additional) echo '&nbsp;'.$additional;
    echo '</th>';
    echo '</tr>';
    echo '<tr><td class="e">';
    if (!empty($titleonly)) {
        print_section_footer();
        $output .= ob_get_clean();
        while(@ob_get_clean());
        ob_start();
    }
}

// セクションの終了
function print_section_footer()
{
    echo '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '<br/>';
}

// サブセクションの開始
function print_subsection_header($string, $additional = null)
{
    global $titleonly, $output;
    if (!empty($titleonly)) {
        while(@ob_get_clean());
        ob_start();
    }
    fs_box_start();
    echo '<div><B>【'.$string.'】';
    if ($additional) echo '&nbsp;'.$additional;
    echo '</B></div>';
    echo '<br />';
    if (!empty($titleonly)) {
        print_subsection_footer();
        $output .= ob_get_clean();
        while(@ob_get_clean());
        ob_start();
    }
}

// サブセクションの終了
function print_subsection_footer()
{
    fs_box_end();
}

// サブサブセクションの開始
function print_subsubsection_header($string, $additional = null)
{
    global $titleonly, $output;
    if (!empty($titleonly)) {
        while(@ob_get_clean());
        ob_start();
    }
    fs_box_start();
    echo '<div><B>（'.$string.'）';
    if ($additional) echo '&nbsp;'.$additional;
    echo '</B></div>';
    echo '<br />';
    if (!empty($titleonly)) {
        print_subsubsection_footer();
        $output .= ob_get_clean();
        while(@ob_get_clean());
        ob_start();
    }
}

// サブサブセクションの終了
function print_subsubsection_footer()
{
    fs_box_end();
}

// ----------------------------------------------
// print_box_start()の上位互換 
// Moodle2.0からは$OUTPUT->box_start()を使用する
function fs_box_start($classes = 'generalbox', $id = null, $return=false)
{
    if (class_exists('core_renderer')) {
        global $OUTPUT;
        $result = $OUTPUT->box_start($classes, $id);
        if ($return) return $result;
        echo $result;
    } else print_box_start($classes, $id, $return);
}

function fs_box_end($return=false)
{
    if (class_exists('core_renderer')) {
        global $OUTPUT;
        $result = $OUTPUT->box_end();
        if ($return) return $result;
        echo $result;
    } else print_box_end($return);
}

function fs_print_box($message, $classes='generalbox', $ids='', $return=false)
{
    if (class_exists('core_renderer')) {
        global $OUTPUT;
        $result = $OUTPUT->box($message, $classes, $ids);
        if ($return) return $result;
        echo $result;
    } else print_box($message, $classes, $ids, $return);
}

// ----------------------------------
// helpbutton()
// http://docs.moodle.org/dev/Deprecated_functions_in_2.0#helpbutton_.280.29
// http://docs.moodle.org/dev/Output_API#help_icon
/**
 * Print a help button.
 *
 * @uses $CFG
 * @param string $page  The keyword that defines a help page
 * @param string $title The title of links, rollover tips, alt tags etc
 *           'Help with' (or the language equivalent) will be prefixed and '...' will be stripped.
 * @param string $module Which module is the page defined in
 * @param mixed $image Use a help image for the link?  (true/false/"both")
 * @param boolean $linktext If true, display the title next to the help icon.
 * @param string $text If defined then this text is used in the page, and
 *           the $page variable is ignored.
 * @param boolean $return If true then the output is returned as a string, if false it is printed to the current page.
 * @param string $imagetext The full text for the helpbutton icon. If empty use default help.gif
 * @return string
 * @todo Finish documenting this function
 */
// これはMoodle1.9のlib/weblib.phpのもの
// function helpbutton ($page, $title, $module='moodle', $image=true, $linktext=false, $text='', $return=false,
//                     $imagetext='') {
// 以下はfs_moodleでの使用例．lib/fs_moodle以外にも本体内に随分とこのスタイルのヘルプボタンを仕込んでしまっている．
//echo helpbutton('settingofeventcolor', get_string('settingofeventcolor', 'fs_moodle'), 'fs_moodle', true, false, '', true);
// <?php helpbutton('blogexport', get_string('blogexport', 'fs_moodle'), 'fs_moodle', true, false, '', false);

function fs_helpbutton($page, $title, $module='moodle', $image=true, $linktext=false, $text='', $return=false, $imagetext='')
{
    if (class_exists('core_renderer')) {
        global $OUTPUT;
/*
        $helpicon = new help_icon();
        $helpicon->page = $page;
        $helpicon->text = $title;
        $helpicon->module = $module;
        $result = $OUTPUT->help_icon($helpicon);
*/
        $result = $OUTPUT->help_icon($page, $module);
        if ($return) return $result;
    } else {
        $result = helpbutton($page, $title, $module='moodle', $image=true, $linktext=false, $text='', $return=false, $imagetext='');
        if ($return) return $result;
    }
    echo $result;
}

?>
