<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_mnetProxySettings()
{
    global $CFG, $fsCFG;

    print_section_header('MoodleネットワークのProxy関係の設定');
    print_subsection_header('Proxyの使用を制限', link2shirai(215));
    echo '　現在，このサーバはインターネットへのアクセスにProxyを';
    if (isset($CFG->proxyhost)) {
        echo color_blue('使用する').'設定です．';
        newline();
        fs_box_start();
        echo 'Proxyホスト名（$CFG->proxyhost）：'.$CFG->proxyhost.'<br />';
        echo 'Proxyポート番号（$CFG->proxyport）：'.$CFG->proxyport.'<br />';
        echo 'Proxyタイプ（$CFG->proxytype）：'.$CFG->proxytype.'<br />';
        echo 'Proxyユーザ名（$CFG->username）：';
        if (empty($CFG->proxyuser)) echo '（空）'; else echo $CFG->proxyuser;
        echo '<br />';
        echo 'Proxyパスワード（$CFG->proxypassword）：';
        if (empty($CFG->proxypassword)) echo '（空）'; else echo $CFG->proxypassword;
        echo '<br />';
        fs_box_end();
        newline();
    } else {
        echo color_blue('使用しない').'設定です．';
        newline();
    }
    echo '　Moodleネットワークを利用する際にProxyを使用しないホスト名は'.color_blue('moodledata/config/fscofig_option.php').'で'.color_blue('fs_add_mnet_exception_usingproxy()関数').'を用いて設定します．';
    echo '詳しくは'.link2fs_wiki('fs_add_mnet_exception_usingproxy').'のページをご覧下さい．';
    newline();
    echo '　例外アドレスはfs_add_mnet_exception_usingproxy()によって';
    if ((isset($fsCFG->mnet_proxy_addr) and (count($fsCFG->mnet_proxy_addr) > 0)) or !empty($fsCFG->mnet_proxy_disable)) {
        echo color_blue('設定されています．');
        newline();
        if (!empty($fsCFG->mnet_proxy_addr)) {
            fs_box_start();
            foreach ($fsCFG->mnet_proxy_addr as $except_addr) echo '・['.$except_addr.']＝'.gethostbyname($except_addr).'<br />';
            fs_box_end();
        }
        newline();
        if (!empty($fsCFG->mnet_proxy_disable)) {
            echo '　なお，'.color_blue('fs_add_mnet_exception_usingproxy()：引数なし').'が設定されているため，';
            echo 'もし，例外アドレスが指定されていたとしても関係なしに';
            echo color_red('MoodleネットワークのサイトにはProxyを一切使わずにアクセスします．');
            newline();
        }
    } else {
        echo color_blue('設定されていません．');
        newline();
    }

    print_subsection_footer();
    print_section_footer();
}

fsconfig_check_mnetProxySettings();

?>