function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * Contain the logic for modals.
 *
 * @module     core/modal
 * @class      modal
 * @package    core
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */}define("core/modal",["jquery","core/templates","core/notification","core/key_codes","core/custom_interaction_events","core/modal_backdrop","core/event","core/modal_events","core/local/aria/focuslock","core/pending","core/fullscreen"],(function($,Templates,Notification,KeyCodes,CustomEvents,ModalBackdrop,Event,ModalEvents,FocusLock,Pending,Fullscreen){var backdropPromise,SELECTORS_CONTAINER='[data-region="modal-container"]',SELECTORS_MODAL='[data-region="modal"]',SELECTORS_HEADER='[data-region="header"]',SELECTORS_TITLE='[data-region="title"]',SELECTORS_BODY='[data-region="body"]',SELECTORS_FOOTER='[data-region="footer"]',SELECTORS_HIDE='[data-action="hide"]',SELECTORS_DIALOG="[role=dialog]",SELECTORS_FORM="form",SELECTORS_MENU_BAR="[role=menubar]",SELECTORS_HAS_Z_INDEX=".moodle-has-zindex",TEMPLATES_LOADING="core/loading",TEMPLATES_BACKDROP="core/modal_backdrop",modalCounter=0,Modal=function(root){this.root=$(root),this.modal=this.root.find(SELECTORS_MODAL),this.header=this.modal.find(SELECTORS_HEADER),this.headerPromise=$.Deferred(),this.title=this.header.find(SELECTORS_TITLE),this.titlePromise=$.Deferred(),this.body=this.modal.find(SELECTORS_BODY),this.bodyPromise=$.Deferred(),this.footer=this.modal.find(SELECTORS_FOOTER),this.footerPromise=$.Deferred(),this.hiddenSiblings=[],this.isAttached=!1,this.bodyJS=null,this.footerJS=null,this.modalCount=modalCounter++,this.attachmentPoint=document.createElement("div"),document.body.append(this.attachmentPoint),this.root.is(SELECTORS_CONTAINER)||Notification.exception({message:"Element is not a modal container"}),this.modal.length||Notification.exception({message:"Container does not contain a modal"}),this.header.length||Notification.exception({message:"Modal is missing a header region"}),this.title.length||Notification.exception({message:"Modal header is missing a title region"}),this.body.length||Notification.exception({message:"Modal is missing a body region"}),this.footer.length||Notification.exception({message:"Modal is missing a footer region"}),this.registerEventListeners()};return Modal.prototype.attachToDOM=function(){this.getAttachmentPoint().append(this.root),this.isAttached||(FocusLock.trapFocus(this.root[0]),this.bodyJS&&(Templates.runTemplateJS(this.bodyJS),this.bodyJS=null),this.footerJS&&(Templates.runTemplateJS(this.footerJS),this.footerJS=null),this.isAttached=!0)},Modal.prototype.countOtherVisibleModals=function(){var count=0;return $("body").find(SELECTORS_CONTAINER).each(function(index,element){element=$(element),!this.root.is(element)&&element.hasClass("show")&&count++}.bind(this)),count},Modal.prototype.getBackdrop=function(){return backdropPromise||(backdropPromise=Templates.render(TEMPLATES_BACKDROP,{}).then((function(html){var element=$(html);return new ModalBackdrop(element)})).fail(Notification.exception)),backdropPromise},Modal.prototype.getRoot=function(){return this.root},Modal.prototype.getModal=function(){return this.modal},Modal.prototype.getTitle=function(){return this.title},Modal.prototype.getBody=function(){return this.body},Modal.prototype.getFooter=function(){return this.footer},Modal.prototype.getTitlePromise=function(){return this.titlePromise},Modal.prototype.getBodyPromise=function(){return this.bodyPromise},Modal.prototype.getFooterPromise=function(){return this.footerPromise},Modal.prototype.getModalCount=function(){return this.modalCount},Modal.prototype.setTitle=function(value){var title=this.getTitle();this.titlePromise=$.Deferred(),this.asyncSet(value,title.html.bind(title)).then(function(){this.titlePromise.resolve(title)}.bind(this)).catch(Notification.exception)},Modal.prototype.setBody=function(value){this.bodyPromise=$.Deferred();var body=this.getBody();if("string"==typeof value)body.html(value),Event.notifyFilterContentUpdated(body),this.getRoot().trigger(ModalEvents.bodyRendered,this),this.bodyPromise.resolve(body);else{var jsPendingId="amd-modal-js-pending-id-"+this.getModalCount();M.util.js_pending(jsPendingId);var contentPromise=null;if(body.css("overflow","hidden"),"pending"==(value=$.when(value)).state()){var height=body.innerHeight();height<100&&(height=100),body.animate({height:height+"px"},150),body.html(""),contentPromise=Templates.render(TEMPLATES_LOADING,{}).then((function(html){var loadingIcon=$(html).hide();return body.html(loadingIcon),loadingIcon.fadeIn(150),$.when(loadingIcon.promise(),value)})).then((function(loadingIcon){return loadingIcon.fadeOut(100).promise()})).then((function(){return value}))}else contentPromise=value;contentPromise.then(function(html,js){var result=null;if(this.isVisible()){body.css("opacity",0);var currentHeight=body.innerHeight();body.html(html),body.css("height","");var newHeight=body.innerHeight();body.css("height",currentHeight+"px"),result=body.animate({height:newHeight+"px",opacity:1},{duration:150,queue:!1}).promise()}else body.html(html);return js&&(this.isAttached?Templates.runTemplateJS(js):this.bodyJS=js),result}.bind(this)).then(function(result){return Event.notifyFilterContentUpdated(body),this.getRoot().trigger(ModalEvents.bodyRendered,this),result}.bind(this)).then(function(){this.bodyPromise.resolve(body)}.bind(this)).fail(Notification.exception).always((function(){body.css("height",""),body.css("overflow",""),body.css("opacity",""),M.util.js_complete(jsPendingId)})).fail(Notification.exception)}},Modal.prototype.setFooter=function(value){this.showFooter(),this.footerPromise=$.Deferred();var footer=this.getFooter();"string"==typeof value?(footer.html(value),this.footerPromise.resolve(footer)):Templates.render(TEMPLATES_LOADING,{}).then((function(html){return footer.html(html),value})).then(function(html,js){return footer.html(html),js&&(this.isAttached?Templates.runTemplateJS(js):this.footerJS=js),footer}.bind(this)).then(function(footer){this.footerPromise.resolve(footer)}.bind(this)).catch(Notification.exception)},Modal.prototype.hasFooterContent=function(){return!!this.getFooter().children().length},Modal.prototype.hideFooter=function(){this.getFooter().addClass("hidden")},Modal.prototype.showFooter=function(){this.getFooter().removeClass("hidden")},Modal.prototype.setLarge=function(){this.isLarge()||this.getModal().addClass("modal-lg")},Modal.prototype.isLarge=function(){return this.getModal().hasClass("modal-lg")},Modal.prototype.setSmall=function(){this.isSmall()||this.getModal().removeClass("modal-lg")},Modal.prototype.isSmall=function(){return!this.getModal().hasClass("modal-lg")},Modal.prototype.calculateZIndex=function(){var items=$(SELECTORS_DIALOG+", "+SELECTORS_MENU_BAR+", "+SELECTORS_HAS_Z_INDEX),zIndex=parseInt(this.root.css("z-index"));return items.each((function(index,item){var itemZIndex=(item=$(item)).css("z-index")?parseInt(item.css("z-index")):0;itemZIndex>zIndex&&(zIndex=itemZIndex)})),zIndex},Modal.prototype.isVisible=function(){return this.root.hasClass("show")},Modal.prototype.hasFocus=function(){var target=$(document.activeElement);return this.root.is(target)||this.root.has(target).length},Modal.prototype.hasTransitions=function(){return this.getRoot().hasClass("fade")},Modal.prototype.getAttachmentPoint=function(){return $(Fullscreen.getElement()||this.attachmentPoint)},Modal.prototype.show=function(){if(this.isVisible())return $.Deferred().resolve();var pendingPromise=new Pending("core/modal:show");return this.hasFooterContent()?this.showFooter():this.hideFooter(),this.attachToDOM(),this.getBackdrop().then(function(backdrop){var newIndex=this.calculateZIndex()+2,newBackdropIndex=newIndex-1;this.root.css("z-index",newIndex),backdrop.setZIndex(newBackdropIndex),backdrop.show(),this.root.removeClass("hide").addClass("show"),this.accessibilityShow(),this.getModal().focus(),$("body").addClass("modal-open"),this.root.trigger(ModalEvents.shown,this)}.bind(this)).then(pendingPromise.resolve)},Modal.prototype.hideIfNotForm=function(){0==this.modal.find(SELECTORS_FORM).length&&this.hide()},Modal.prototype.hide=function(){this.getBackdrop().done(function(backdrop){FocusLock.untrapFocus(),this.countOtherVisibleModals()||(backdrop.hide(),$("body").removeClass("modal-open"));var currentIndex=parseInt(this.root.css("z-index"));this.root.css("z-index",""),backdrop.setZIndex(currentIndex-3),this.accessibilityHide(),this.hasTransitions()?this.getRoot().one("transitionend webkitTransitionEnd oTransitionEnd",function(){this.getRoot().removeClass("show").addClass("hide")}.bind(this)):this.getRoot().removeClass("show").addClass("hide"),$(document.body).find(this.getRoot()).length&&$(document.body).append(this.getRoot()),this.root.trigger(ModalEvents.hidden,this)}.bind(this))},Modal.prototype.destroy=function(){this.hide(),this.root.remove(),this.root.trigger(ModalEvents.destroyed,this),this.attachmentPoint.remove()},Modal.prototype.accessibilityShow=function(){$("body").children().each(function(index,child){if(!this.root.is(child)){var hidden=(child=$(child)).attr("aria-hidden");"true"!==hidden&&(child.data("previous-aria-hidden",hidden),this.hiddenSiblings.push(child),child.attr("aria-hidden","true"))}}.bind(this)),this.root.attr("aria-hidden","false")},Modal.prototype.accessibilityHide=function(){this.root.attr("aria-hidden","true"),$.each(this.hiddenSiblings,(function(index,sibling){var previousValue=(sibling=$(sibling)).data("previous-aria-hidden");void 0===previousValue?sibling.removeAttr("aria-hidden"):sibling.attr("aria-hidden",previousValue)})),this.hiddenSiblings=[]},Modal.prototype.registerEventListeners=function(){this.getRoot().on("keydown",function(e){this.isVisible()&&e.keyCode==KeyCodes.escape&&(this.removeOnClose?this.destroy():this.hide())}.bind(this)),this.getRoot().click(function(e){$(e.target).closest(SELECTORS_MODAL).length||$(e.target).closest(SELECTORS_CONTAINER).length&&this.hideIfNotForm()}.bind(this)),CustomEvents.define(this.getModal(),[CustomEvents.events.activate]),this.getModal().on(CustomEvents.events.activate,SELECTORS_HIDE,function(e,data){this.hide(),data.originalEvent.preventDefault()}.bind(this))},Modal.prototype.registerCloseOnCancel=function(){this.getModal().on(CustomEvents.events.activate,this.getActionSelector("cancel"),function(e,data){var cancelEvent=$.Event(ModalEvents.cancel);this.getRoot().trigger(cancelEvent,this),cancelEvent.isDefaultPrevented()||(data.originalEvent.preventDefault(),this.removeOnClose?this.destroy():this.hide())}.bind(this))},Modal.prototype.registerCloseOnSave=function(){this.getModal().on(CustomEvents.events.activate,this.getActionSelector("save"),function(e,data){var saveEvent=$.Event(ModalEvents.save);this.getRoot().trigger(saveEvent,this),saveEvent.isDefaultPrevented()||(data.originalEvent.preventDefault(),this.removeOnClose?this.destroy():this.hide())}.bind(this))},Modal.prototype.asyncSet=function(value,setFunction){var p=value;return"object"===_typeof(value)&&value.hasOwnProperty("then")||(p=$.Deferred()).resolve(value),p.then((function(content){setFunction(content)})).fail(Notification.exception),p},Modal.prototype.setButtonText=function(action,value){var button=this.getFooter().find(this.getActionSelector(action));if(!button)throw new Error("Unable to find the '"+action+"' button");return this.asyncSet(value,button.text.bind(button))},Modal.prototype.getActionSelector=function(action){return"[data-action='"+action+"']"},Modal.prototype.setRemoveOnClose=function(remove){this.removeOnClose=remove},Modal}));

//# sourceMappingURL=modal.min.js.map