/**
 * Controls the notification popover in the nav bar.
 *
 * See template: message_popup/notification_popover
 *
 * @module     message_popup/notification_popover_controller
 * @class      notification_popover_controller
 * @package    message_popup
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("message_popup/notification_popover_controller",["jquery","core/ajax","core/templates","core/str","core/url","core/notification","core/custom_interaction_events","core/popover_region_controller","message_popup/notification_repository","message_popup/notification_area_events"],(function($,Ajax,Templates,Str,URL,DebugNotification,CustomEvents,PopoverController,NotificationRepo,NotificationAreaEvents){var SELECTORS_MARK_ALL_READ_BUTTON='[data-action="mark-all-read"]',SELECTORS_ALL_NOTIFICATIONS_CONTAINER='[data-region="all-notifications"]',SELECTORS_NOTIFICATION='[data-region="notification-content-item-container"]',SELECTORS_UNREAD_NOTIFICATION='[data-region="notification-content-item-container"].unread',SELECTORS_NOTIFICATION_LINK='[data-action="content-item-link"]',SELECTORS_COUNT_CONTAINER='[data-region="count-container"]',NotificationPopoverController=function(element){PopoverController.call(this,element),this.markAllReadButton=this.root.find(SELECTORS_MARK_ALL_READ_BUTTON),this.unreadCount=0,this.lastQueried=0,this.userId=this.root.attr("data-userid"),this.container=this.root.find(SELECTORS_ALL_NOTIFICATIONS_CONTAINER),this.limit=20,this.offset=0,this.loadedAll=!1,this.initialLoad=!1,this.unreadCount=this.root.find(SELECTORS_COUNT_CONTAINER).html()};return(NotificationPopoverController.prototype=Object.create(PopoverController.prototype)).constructor=NotificationPopoverController,NotificationPopoverController.prototype.updateButtonAriaLabel=function(){this.isMenuOpen()?Str.get_string("hidenotificationwindow","message").done(function(string){this.menuToggle.attr("aria-label",string)}.bind(this)):this.unreadCount?Str.get_string("shownotificationwindowwithcount","message",this.unreadCount).done(function(string){this.menuToggle.attr("aria-label",string)}.bind(this)):Str.get_string("shownotificationwindownonew","message").done(function(string){this.menuToggle.attr("aria-label",string)}.bind(this))},NotificationPopoverController.prototype.getContent=function(){return this.container},NotificationPopoverController.prototype.getOffset=function(){return this.offset},NotificationPopoverController.prototype.incrementOffset=function(){this.offset+=this.limit},NotificationPopoverController.prototype.hasDoneInitialLoad=function(){return this.initialLoad},NotificationPopoverController.prototype.hasLoadedAllContent=function(){return this.loadedAll},NotificationPopoverController.prototype.setLoadedAllContent=function(val){this.loadedAll=val},NotificationPopoverController.prototype.renderUnreadCount=function(){var element=this.root.find(SELECTORS_COUNT_CONTAINER);this.unreadCount?(element.text(this.unreadCount),element.removeClass("hidden")):element.addClass("hidden")},NotificationPopoverController.prototype.hideUnreadCount=function(){this.root.find(SELECTORS_COUNT_CONTAINER).addClass("hidden")},NotificationPopoverController.prototype.getNotificationElement=function(id){var element=this.root.find(SELECTORS_NOTIFICATION+'[data-id="'+id+'"]');return 1==element.length?element:null},NotificationPopoverController.prototype.renderNotifications=function(notifications,container){var promises=[];return $.each(notifications,function(index,notification){var offset=this.getOffset()-this.limit;notification.viewmoreurl=URL.relativeUrl("/message/output/popup/notifications.php",{notificationid:notification.id,offset:offset});var notificationurlparams={notificationid:notification.id};notification.contexturl=URL.relativeUrl("message/output/popup/mark_notification_read.php",notificationurlparams);var promise=Templates.render("message_popup/notification_content_item",notification).then((function(html,js){return{html:html,js:js}}));promises.push(promise)}.bind(this)),$.when.apply($,promises).then((function(){$.each(arguments,(function(index,argument){container.append(argument.html),Templates.runTemplateJS(argument.js)}))}))},NotificationPopoverController.prototype.loadMoreNotifications=function(){if(this.isLoading||this.hasLoadedAllContent())return $.Deferred().resolve();this.startLoading();var request={limit:this.limit,offset:this.getOffset(),useridto:this.userId},container=this.getContent();return NotificationRepo.query(request).then(function(result){var notifications=result.notifications;return this.unreadCount=result.unreadcount,this.lastQueried=Math.floor((new Date).getTime()/1e3),this.setLoadedAllContent(!notifications.length||notifications.length<this.limit),this.initialLoad=!0,this.updateButtonAriaLabel(),!!notifications.length&&(this.incrementOffset(),this.renderNotifications(notifications,container))}.bind(this)).always(function(){this.stopLoading()}.bind(this))},NotificationPopoverController.prototype.markAllAsRead=function(){this.markAllReadButton.addClass("loading");var request={useridto:this.userId,timecreatedto:this.lastQueried};return NotificationRepo.markAllAsRead(request).then(function(){this.unreadCount=0,this.root.find(SELECTORS_UNREAD_NOTIFICATION).removeClass("unread")}.bind(this)).always(function(){this.markAllReadButton.removeClass("loading")}.bind(this))},NotificationPopoverController.prototype.registerEventListeners=function(){CustomEvents.define(this.root,[CustomEvents.events.activate]),this.root.on(CustomEvents.events.activate,SELECTORS_MARK_ALL_READ_BUTTON,function(e,data){this.markAllAsRead(),e.stopPropagation(),data.originalEvent.preventDefault()}.bind(this)),this.root.on(CustomEvents.events.activate,SELECTORS_NOTIFICATION_LINK,function(e){var element=$(e.target).closest(SELECTORS_NOTIFICATION);element.hasClass("unread")&&(this.unreadCount--,element.removeClass("unread")),e.stopPropagation()}.bind(this)),this.root.on(this.events().menuOpened,function(){this.hideUnreadCount(),this.updateButtonAriaLabel(),this.hasDoneInitialLoad()||this.loadMoreNotifications()}.bind(this)),this.root.on(this.events().menuClosed,function(){this.renderUnreadCount(),this.updateButtonAriaLabel()}.bind(this)),this.root.on(this.events().startLoading,function(){this.getContent().attr("aria-busy","true")}.bind(this)),this.root.on(this.events().stopLoading,function(){this.getContent().attr("aria-busy","false")}.bind(this)),this.getContentContainer().on(CustomEvents.events.scrollBottom,function(){this.isLoading||this.hasLoadedAllContent()||this.loadMoreNotifications()}.bind(this)),CustomEvents.define(this.getContentContainer(),[CustomEvents.events.scrollLock]),$(document).on(NotificationAreaEvents.notificationShown,function(e,notification){if(!notification.read){var element=this.getNotificationElement(notification.id);element&&element.removeClass("unread"),this.unreadCount--,this.renderUnreadCount()}}.bind(this))},NotificationPopoverController}));

//# sourceMappingURL=notification_popover_controller.min.js.map