################################################################################
#
# 桼ƥƥ
#
################################################################################
package Util;
#use strict;
#use Net::SMTP;
#===============================================================================
#  Ϥ줿ʸURL󥳡ɤ֤ޤ
#===============================================================================
sub url_encode {
	my $retstr = shift;
	$retstr =~ s/([^ 0-9A-Za-z])/sprintf("%%%.2X", ord($1))/eg;
	$retstr =~ tr/ /+/;
	return $retstr;
}

#===============================================================================
#  Ϥ줿ʸURLǥɤ֤ޤ
#===============================================================================
sub url_decode{
	my $retstr = shift;
	$retstr =~ tr/+/ /;
	$retstr =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;
	return $retstr;
}

#===============================================================================
#  ե̾
#===============================================================================
sub make_filename {
	my $dir  = shift;
	my $file = shift;
	my $ext  = shift;
	
	return $dir."/".$file.".".$ext;
}

#===============================================================================
#  Ϥ줿ʸHTML򥨥פ֤ޤ
#===============================================================================
sub escapeHTML {
	my($retstr) = shift;
	my %table = (
		'&' => '&amp;',
		'"' => '&quot;',
		'<' => '&lt;',
		'>' => '&gt;',
	);
	$retstr =~ s/([&\"<>])/$table{$1}/go;
	return $retstr;
}


#===============================================================================
# դեޥåȤޤ
#===============================================================================
sub format_date {
	my $t = shift;
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($t);
	return sprintf("%04dǯ%02d%02d %02d%02dʬ%02d",
	               $year+1900,$mon+1,$mday,$hour,$min,$sec);
}

#===============================================================================
# ʸξüζڤȤޤ
#===============================================================================
sub trim {
	my $text = shift;
	if(!defined($text)){
		return "";
	}
	$text =~ s/^(?:\s)+//o;
	$text =~ s/(?:\s)+$//o;
	return $text;
}


#===============================================================================
# ʸΤߤޤ
#===============================================================================
sub delete_tag {
	my $text = shift;
	$text =~ s/<(.|\s)+?>//g;
	return $text;
}

#===============================================================================
# ͤɤåޤ
#===============================================================================
sub check_numeric {
	my $text = shift;
	if($text =~ /^[0-9]+$/){
		return 1;
	} else {
		return 0;
	}
}


#===============================================================================
# Ԥ˥᡼ޤ
# SMTP硢ƤӽФ¦use Net::SMTPƤ
#===============================================================================
sub send_mail {
	my $wiki    = shift;
	my $subject = Jcode->new(shift)->mime_encode();
	my $content = &Jcode::convert(shift,'jis');
	
	if(($wiki->config('send_mail') eq "" && $wiki->config('smtp_server') eq "") ||
	   $wiki->config('admin_mail') eq ""){
		return;
	}
	
	my $mail = "Subject: $subject\n".
	           "From: ".$wiki->config('admin_mail')."\n".
	           "Content-Transfer-Encoding: 7bit\n".
	           "Content-Type: text/plain; charset=\"ISO-2022-JP\"\n".
	           "Reply-To: ".$wiki->config('admin_mail')."\n".
	           "\n".
	           $content;
	
	# sendmailޥɤ
	if($wiki->config('send_mail') ne ""){
		open(MAIL,"| ".$wiki->config('send_mail')." ".$wiki->config('admin_mail'));
		print MAIL $mail;
		close(MAIL);
		
	# Net::SMTP
	} else {
		#use Net::SMTP;
		my $smtp = Net::SMTP->new($wiki->config('smtp_server'));
		$smtp->mail($wiki->config('admin_mail'));
		$smtp->to($wiki->config('admin_mail'));
		$smtp->data();
		$smtp->datasend($mail);
		$smtp->quit();
	}
}

#===============================================================================
# äɤåޤ
#===============================================================================
sub handyphone {
	my $ua = $ENV{'HTTP_USER_AGENT'};
	if(!defined($ua)){
		return 0;
	}
	if($ua=~/^DoCoMo\// || $ua=~ /^J-PHONE\// || $ua=~ /UP\.Browser/){
		return 1;
	} else {
		return 0;
	}
}

#===============================================================================
# ɤ߹ߥϥåե󥹤֤ޤ
#===============================================================================
sub load_config_hash {
	my $wiki     = shift;
	my $filename = shift;
	my $text = &load_config_text($wiki,$filename);
	my @lines = split(/\n/,$text);
	my $hash = {};
	foreach my $line (@lines){
		$line = &trim($line);
		if(index($line,"#")==0 || $line eq "\n" || $line eq "\r" || $line eq "\r\n"){
			next;
		}
		my ($name,@values) = split(/=/,$line);
		$name = &trim($name);
		my $value = &trim(join("=",@values));
		$hash->{$name} = $value;
	}
	return $hash;
}

#===============================================================================
# ɤ߹ߥץ졼ƥȤ֤ޤ
#===============================================================================
sub load_config_text {
	my $wiki     = shift;
	my $filename = shift;
	my $fullpath = $filename;
	if(defined($wiki)){
		$fullpath = $wiki->config('config_dir')."/$filename";
	}
	
	if(defined($wiki->{config_cache}->{$fullpath})){
		return $wiki->{config_cache}->{$fullpath};
	}
	
	open(CONFIG,$fullpath) or return "";
	binmode(CONFIG);
	my $buf = "";
	while(my $line = <CONFIG>){
		$buf .= $line;
	}
	close(CONFIG);
	
	$buf =~ s/\r\n/\n/g;
	$buf =~ s/\r/\n/g;
	
	$wiki->{config_cache}->{$fullpath} = $buf;
	
	return $buf;
}

#===============================================================================
# ϥåե󥹤Ϥ줿Υե˽񤭽Фޤ
#
# Util::save_config_hash(ե̾,ϥåե);
#===============================================================================
sub save_config_hash {
	my $wiki     = shift;
	my $filename = shift;
	my $hash     = shift;
	my $text = "";
	foreach my $key (keys(%$hash)){
		$text .= $key."=".$hash->{$key}."\n";
	}
	&save_config_text($wiki,$filename,$text);
}

#===============================================================================
# ƥȤϤ줿Υե˽񤭽Фޤ
#
# Util::save_config_hash(ե̾,ƥ);
#===============================================================================
sub save_config_text {
	my $wiki     = shift;
	my $filename = shift;
	my $text     = shift;
	
	$text =~ s/\r\n/\n/g;
	$text =~ s/\r/\n/g;
	
	my $fullpath = $filename;
	if(defined($wiki)){
		$fullpath = $wiki->config('config_dir')."/$filename";
	}
	open(CONFIG,">$fullpath") or die $!;
	print CONFIG $text;
	close(CONFIG);
	
	$wiki->{config_cache}->{$fullpath} = $text;
}

#===============================================================================
# 顼å
# 饤ץ饰󤫤饨顼å֤˻ѤƤ
#===============================================================================
sub error {
	my $message = shift;
	return "<font class=\"error\">".&Util::escapeHTML($message)."</font>";
}

#===============================================================================
# URLGETꥯȤȯԤ쥹ݥ󥹤ΥܥǥֵѤޤ
# δؿƤӽФ硢use LWP::UserAgent;ԤäƤ
#===============================================================================
sub get_response {
	my $wiki = shift;
	my $url  = shift;
	
	my $ua  = LWP::UserAgent->new();
	my $req = HTTP::Request->new('GET',$url);
	
	# ץ
	my $proxy_host = $wiki->config('proxy_host');
	my $proxy_port = $wiki->config('proxy_port');
	my $proxy_user = $wiki->config('proxy_user');
	my $proxy_pass = $wiki->config('proxy_pass');
	
	if($proxy_host ne "" && $proxy_port ne ""){
		$ua->proxy("http","http://$proxy_host:$proxy_port");
		if($proxy_user ne "" && $proxy_pass ne ""){
			$req->header('Proxy-Authorization'=>"Basic ".&MIME::Base64::encode("$proxy_user:$proxy_pass"));
		}
	}
	
	# ꥯȤȯ
	my $res = $ua->request($req);
	return $res->content();
}

1;