############################################################
#
# ǥեȤΥȥ졼ץ饰
#
############################################################
package Wiki::DefaultStorage;
#use strict;
#===========================================================
# 󥹥ȥ饯
#===========================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	my $self  = {};
	$self->{wiki}  = $wiki;
#	$self->{content_cache} = {};
	$self->{exists_cache}  = {};
	return bless $self,$class;
}

#===========================================================
# ڡ
#===========================================================
sub get_page {
	my $self = shift;
	my $page = shift;
	
#	if(defined($self->{content_cache}->{$page})){
#		return $self->{content_cache}->{$page};
#	}
	
	my $content = "";
	my $filename = &Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki");
	if(-e $filename){
		open(DATA,$filename) or die $!;
		binmode(DATA);
		while(<DATA>){
			$content = $content.$_;
		}
		close(DATA);
	}
	
#	$self->{content_cache}->{$page} = $content;
	return $content;
}

#==============================================================================
# ڡ¸
#==============================================================================
sub save_page {
	my $self = shift;
	my $page = shift;
	my $content = shift;
	
	$content = '' if($content =~ /^[\r\n]+$/s); # added for opera
	
	# ڡ̾ȥڡƤ
	$page = Util::trim($page);
	$content =~ s/\r\n/\n/g;
	$content =~ s/\r/\n/g;
    
	# Хåå
	my $BACKUP = $self->get_page($page);
	if($BACKUP ne ""){
		open(DATA,">".&Util::make_filename($self->{wiki}->config('backup_dir'),&Util::url_encode($page),"bak")) or die $!;
		binmode(DATA);
		print DATA $BACKUP;
		close(DATA);
	}
	
	# 񤭹
	if($content eq ""){
		unlink(&Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki"));
		unlink(&Util::make_filename($self->{wiki}->config('backup_dir'),&Util::url_encode($page),"bak"));
	} else {
		open(DATA,">".&Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki")) or die $!;
		binmode(DATA);
		print DATA $content;
		close(DATA);
	}
}

#===========================================================
# ڡΰ
#===========================================================
sub get_page_list {
	my $self = shift;
	opendir(DIR,$self->{wiki}->config('data_dir')) or die $!;
	my ($entry,@list);
	while($entry = readdir(DIR)){
		my $name = substr($entry,0,rindex($entry,"."));
		my $type = substr($entry,rindex($entry,"."));
		if($type eq ".wiki"){
			push(@list,&Util::url_decode($name));
		}
	}
	closedir(DIR);
	@list = sort { $a cmp $b } @list;
	return @list;
}

#==============================================================================
# ڡκǽ
#==============================================================================
sub get_last_modified {
	my $self = shift;
	my $page = shift;
	
	my @status = stat(&Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki"));
	return $status[9];
}

#===============================================================================
# ڡ¸ߤ뤫ɤĴ٤
#===============================================================================
sub page_exists {
	my $self = shift;
	my $page = shift;
	if(defined($self->{exists_cache}->{$page})){
		return $self->{exists_cache}->{$page};
	}
	
	my $exists = (-e &Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki"));
	$self->{exists_cache}->{$page} = $exists;
	
	return $exists;
}

#==============================================================================
# Хååץפ(single|all)
#==============================================================================
sub backup_type {
	return "single";
}

#==============================================================================
# Хåå׻ΰޤ
#==============================================================================
sub get_backup_list {
	return undef;
}

#==============================================================================
# Хååפޤ
# backup_type=allξ(0)ꤷޤ
#==============================================================================
sub get_backup {
	my $self = shift;
	my $page = shift;
	my $content = "";
	
	my $filename = &Util::make_filename($self->{wiki}->config('backup_dir'),&Util::url_encode($page),"bak");
	if(-e $filename){
		open(DATA,$filename) or die $!;
		binmode(DATA);
		while(<DATA>){
			$content = $content.$_;
		}
		close(DATA);
	}
	
	return $content;
}

#==============================================================================
# ڡ뤷ޤ
#==============================================================================
sub freeze_page {
	my $self = shift;
	my $pagename = shift;
	
	if(!$self->is_freeze($pagename)){
		open(DATA,">>".$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		binmode(DATA);
		print DATA $pagename."\n";
		close(DATA);
	}
}

#==============================================================================
# ڡޤ
#==============================================================================
sub un_freeze_page {
	my $self = shift;
	my $pagename = shift;
	
	if($self->is_freeze($pagename)){
		my $buf = "";
		open(DATA,$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		while(<DATA>){
			chomp $_;
			if($pagename ne $_){
				$buf .= $_."\n";
			}
		}
		close(DATA);
		
		open(DATA,">".$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		binmode(DATA);
		print DATA $buf;
		close(DATA);
	}
}

#==============================================================================
# ꥹȤ
#==============================================================================
sub get_freeze_list {
	my $self = shift;
	my @list;
	if(!-e $self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')){
		return @list;
	}
	open(DATA,$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
	while(<DATA>){
		chomp $_;
		push @list,$_;
	}
	close(DATA);
	return @list;
}

#==============================================================================
# Ϥڡ椫ɤ٤ޤ
#==============================================================================
sub is_freeze {
	my $self = shift;
	my $pagename = shift;
	foreach($self->get_freeze_list){
		if($_ eq $pagename){
			return 1;
		}
	}
	return 0;
}

1;
