###############################################################################
#
# HTMLѡ
#
###############################################################################
package Wiki::HTMLParser;
use Wiki::Parser;
use vars qw(@ISA);
#use strict;

@ISA = qw(Wiki::Parser);
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = Wiki::Parser->new(shift);
	my $mainflg = shift;
	if(!defined($mainflg) || $mainflg eq ""){ $mainflg = 0; }
	
	$self->{html}  = "";
	$self->{pre}   = "";
	$self->{quote} = "";
	$self->{table} = 0;
	$self->{level} = 0;
	$self->{para}  = 0;
	$self->{p_cnt} = 0;
	$self->{main}  = $mainflg;
	return bless $self,$class;
}

#==============================================================================
# ꥹ
#==============================================================================
sub l_list {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_verbatim;
	$self->end_table;
	
	my $html = join("",@$obj);
	my $plus = 1;
	if($level < $self->{level}){ $plus = -1; }
	if($level==$self->{level}){
		$self->{html} .= "</li>\n";
	}
	while($level != $self->{level}){
		if($plus==1){
			$self->{html} .= "<ul>\n";
		} else {
			$self->{html} .= "</li></ul>\n";
		}
		$self->{level} += $plus;
	}
	
	$self->{html} .= "<li>".$html."\n";
}

#==============================================================================
# ꥹȤνλ
#==============================================================================
sub end_list {
	my $self  = shift;
	while($self->{level}!=0){
		$self->{html} .= "</li>\n</ul>\n";
		$self->{level} += -1;
	}
}

#==============================================================================
# إåɥ饤
#==============================================================================
sub l_headline {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html  = join("",@$obj);
	
	if(!$self->{main}){
		$self->{html} .= "<h".($level+1).">".$html."</h".($level+1).">\n";
	} else {
		$self->{html} .= "<h".($level+1).">".
		                 "<a name=\"p".$self->{p_cnt}."\">".$html."</a>".
		                 "</h".($level+1).">\n";
	}
	$self->{p_cnt}++;
}

#==============================================================================
# ʿ
#==============================================================================
sub l_line {
	my $self = shift;
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	$self->{html} .= "<hr>\n";
}

#==============================================================================
# ڤ
#==============================================================================
sub l_paragraph {
	my $self = shift;
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
}

#==============================================================================
# ѥƥ
#==============================================================================
sub l_verbatim {
	my $self  = shift;
	my $text  = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_table;
	$self->end_quote;
	
	$self->{pre} .= Util::escapeHTML($text)."\n";
}

sub end_verbatim {
	my $self  = shift;
	if($self->{pre} ne ""){
		$self->{html} .= "<pre>".$self->{pre}."</pre>";
		$self->{pre} = "";
	}
}

#==============================================================================
# ơ֥
#==============================================================================
sub l_table {
	my $self = shift;
	my $row  = shift;
	$self->end_list;
	$self->end_verbatim;
	$self->end_quote;
	
	if($self->{table}==0){
		$self->{table}=1;
		$self->{html} .= "<table>\n";
		$self->{html} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{html} .= "<th>".$html."</th>";
		}
		$self->{html} .= "</tr>\n";
	} else {
		$self->{table}=2;
		$self->{html} .= "<tr>";
		foreach(@$row){
			my $html = join("",@$_);
			$self->{html} .= "<td>".$html."</td>";
		}
		$self->{html} .= "</tr>\n";
	}
}

sub end_table {
	my $self = shift;
	if($self->{table}!=0){
		$self->{table} = 0;
		$self->{html} .= "</table>\n";
	}
}

#==============================================================================
# ѡλν
#==============================================================================
sub end_parse {
	my $self = shift;
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
}

#==============================================================================
# Խ񼰤˳ʤ
#==============================================================================
sub l_text {
	my $self = shift;
	my $obj  = shift;
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	my $html = join("",@$obj);
	
	if($self->{para}==0){
		$self->{html} .= "<p>";
		$self->{para} = 1;
	}
	$self->{html} .= $html;
	
	# br⡼ɤꤵƤ<br>­
	if($self->{wiki}->config('br_mode')==1){
		$self->{html} .= "<br>\n";
	}
}

#==============================================================================
# 
#==============================================================================
sub l_quotation {
	my $self = shift;
	my $obj  = shift;
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	my $html = join("",@$obj);
	$self->{quote} .= "<p>".$html."</p>\n";
}

sub end_quote {
	my $self = shift;
	if($self->{quote} ne ""){
		$self->{html} .= "<blockquote>".$self->{quote}."</blockquote>\n";
		$self->{quote} = "";
	}
}

#==============================================================================
# 
#==============================================================================
sub l_explanation {
	my $self = shift;
	my $obj1 = shift;
	my $obj2 = shift;
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html1 = join("",@$obj1);
	my $html2 = join("",@$obj2);
	
	$self->{html} .= "<dl>\n<dt>".$html1."</dt>\n<dd>".$html2."</dd>\n</dl>\n";
}

#==============================================================================
# ܡ
#==============================================================================
sub bold {
	my $self = shift;
	my $text = shift;
	return "<b>".Util::escapeHTML($text)."</b>";
}

#==============================================================================
# å
#==============================================================================
sub italic {
	my $self = shift;
	my $text = shift;
	return "<i>".Util::escapeHTML($text)."</i>";
}

#==============================================================================
# 
#==============================================================================
sub underline {
	my $self = shift;
	my $text = shift;
	return "<u>".Util::escapeHTML($text)."</u>";
}

#==============================================================================
# Ǥä
#==============================================================================
sub denialline {
	my $self = shift;
	my $text = shift;
	return "<s>".Util::escapeHTML($text)."</s>";
}

#==============================================================================
# URL
#==============================================================================
sub url_anchor {
	my $self = shift;
	my $url  = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $url;
	}
	
	if($url eq $name && $url=~/\.(gif|jpg|jpeg|bmp|png)$/i){
		return "<img src=\"".$url."\">";
	} else {
		return "<a href=\"$url\">".Util::escapeHTML($name)."</a>";
	}
}

#==============================================================================
# WikiڡؤΥ
#==============================================================================
sub wiki_anchor {
	my $self = shift;
	my $page = shift;
	my $name = shift;
	
	if(!defined($name) || $name eq ""){
		$name = $page;
	}
	if($self->{wiki}->page_exists($page)){
		return "<a href=\"".$self->{wiki}->config('script_name')."?page=".&Util::url_encode($page)."\" class=\"wikipage\">".
		       &Util::escapeHTML($name)."</a>";
	} else {
		return "<span class=\"nopage\">".&Util::escapeHTML($name)."</span>".
		       "<a href=\"".$self->{wiki}->config('script_name')."?page=".&Util::url_encode($page)."\">?</a>";
	}
}

#==============================================================================
# Υƥ
#==============================================================================
sub text {
	my $self = shift;
	my $text = shift;
	return &Util::escapeHTML($text);
}

#==============================================================================
# ץ饰
#==============================================================================
sub plugin {
	my $self = shift;
	my $text = shift;
	
	my $result = $self->{wiki}->process_inline($text);
	return $result;
}

sub l_plugin {
	my $self = shift;
	my $text = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $result = $self->{wiki}->process_inline($text,1);
	if(defined($result) && $result ne ""){
		$self->{html} .= $result;
	}
}

1;
