################################################################################
#
# CalendarΥϥɥ顣
#
################################################################################
package plugin::calendar::CalendarHandler;
#use strict;
#===============================================================================
# 󥹥ȥ饯
#===============================================================================
sub new {
  my $class = shift;
  my $self = {};
  return bless $self,$class;
}

#===============================================================================
# ڡ̾
#===============================================================================
sub make_pagename {
  my $year  = shift;
  my $month = shift;
  my $day   = shift;
  my $name  = shift;

  return $name."/".$year."-".$month."-".$day;
}

#===============================================================================
# 
#===============================================================================
sub make_calendar {
  my $wiki     = shift;
  my $o_year   = shift;
  my $o_month  = shift;
  my $name     = shift;
  my $template = shift;
  #    my $align    = shift;
  my $id       = shift;

  my @week = ("","","","","","","");
  my $time = time();

  my ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
  $year += 1900;
  $mon  += 1;
  my $today_year  = $year;
  my $today_month = $mon;
  my $today_day   = $mday;

  my $o_yearmon = sprintf("%04d%02d",$o_year,$o_month);

  while ($year!=$o_year || $mon!=$o_month) {
    my $yearmon = sprintf("%04d%02d",$year,$mon);
    if ($o_yearmon > $yearmon) {
      $time += 24 * 60 * 60;
    } else {
      $time -= 24 * 60 * 60;
    }
    ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
    $year += 1900;
    $mon  += 1;
  }

  ($id ne "") and ($id = "id = \"$id\"");

  my $buf = "\n<div class=\"plugin-calendar\" $id>\n"
    ."<table class=\"calendar\">\n";

  $buf .= "<col id=\"calendar-sun\">"
    ."<colgroup span=\"5\" id=\"calendar-weekday\"></colgroup>"
      ."<col id=\"calendar-sat\">\n";

  $buf .= "<thead>"
    ."<tr class=\"navi\"><th colspan=\"7\" id=\"calendar-navi\">"
      ."<a href=\"".$wiki->config('script_name')."?action=CALENDAR&amp;".&make_anchor($year,$mon,-1,$name,$template)."\">&lt;&lt;</a> "
	."<a href=\"".$wiki->config('script_name')."?action=CALENDAR&amp;".&make_anchor($year,$mon, 0,$name,$template)."\">$o_year-$o_month</a> "
	  ."<a href=\"".$wiki->config('script_name')."?action=CALENDAR&amp;".&make_anchor($year,$mon,+1,$name,$template)."\">&gt;&gt;</a></th></tr>\n";
  $buf .= "<tr class=\"week\">";
  foreach (@week) {
    $buf.="<th>".$_."</th>";
  }
  $buf .= "</tr>\n</thead>\n";

  my $time = $time - (($mday-1) * 24 * 60 * 60);
  my $now_month = $mon;

  $buf .= "<tbody>\n";

  my $start_flag = 1;
  while ($now_month==$mon) {
    ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
    $year += 1900;
    $mon  += 1;
    if ($mon!=$now_month) {
      last;
    }
    if ($start_flag) {
      $buf .= "<tr>";
      for (my $i=0;$i<$wday;$i++) {
	$buf .= "<td></td>";
      }
      $start_flag = 0;
    }
    my $page =&make_pagename($year,$mon,$mday,$name);
    # ͽ꤬ True̵ False
    my $have_plan = $wiki->page_exists($page);
    # Ǥ Trueʳ False
    my $is_today = $year==$today_year && $mon==$today_month && $mday==$today_day;
    $buf .= "<td";

    # ̣Τ
    my @class;
    # դ
    $is_today and do { push @class, "today"; };
    # ͽΤ
    $have_plan and do { push @class, "have"; };
    if ($is_today || $have_plan) {
      $buf .= " class=\"".join(" ", @class)."\"";
    }
    $buf .= "\>";

    $buf .= "<a href=\"".$wiki->config('script_name')."?page=".&Util::url_encode($page);
    if (not $have_plan) {
      $buf .= "&amp;template=".&Util::url_encode($template) if defined $template;
    }
    $buf .= "\">$mday</a></td>";

    if ($wday==6) {
      $buf .= "</tr>\n";
      $start_flag = 1;
    }
    $time += 24 * 60 * 60;
  }
  $buf .= "</tr>\n";

  $buf .= "</tbody>\n";

  return $buf."</table>\n</div>\n";
}

#===============================================================================
# 󥫤Υѥ᡼
#===============================================================================
sub make_anchor {
  my $year  = shift;
  my $month = shift;
  my $plus  = shift;
  my $name  = shift;
  my $template = shift;

  my $buf ="";

  $month += $plus;
  if ($month==13) {
    $year += 1;
    $month = 1;
  } elsif ($month==0) {
    $year -= 1;
    $month = 12;
  }

  $buf = "year=".$year."&amp;month=".$month."&amp;name=".Util::url_encode($name);
  $buf .= "&template=".Util::url_encode($template) if defined $template;

  return $buf;
}

#===============================================================================
# ʬ
#===============================================================================
sub make_month_pages {
  my $wiki = shift;
  my $year = shift;
  my $month = shift;
  my $name = shift;

  my $cgi = $wiki->get_CGI;
  my $page = $cgi->param("page");
  my $buf = "";

  for (my $i=31;$i>=1;$i--) {
    my $pagename = &make_pagename($year,$month,$i,$name);
    if ($wiki->page_exists($pagename)) {
      $buf .= $wiki->process_wiki("!!![[$year-$month-$i|$pagename]]\n{{include $pagename}}\n");
    }
  }

  return $buf;
}

#===============================================================================
# κǿxɽ
# RecentCalendarȤΤǥ᥽åɤǤϤʤ⥸塼ؿȤƼ
#===============================================================================
sub make_recent_pages {
  my $wiki  = shift;
  my $name  = quotemeta(shift);
  my $count = shift;
  my $para  = shift;
  my $cgi   = $wiki->get_CGI;

  $count =~ m/([-]?)\s*(\d*)\s*([+]?)/;
  my $reverse      = ($1 ?  1 : 0);
  my $count        = ($2 ? $2 : 1);
  my $ignore_today = ($3 ?  1 : 0);

  my $buf = "";

  my @pages = $wiki->get_page_list;

  # ̾/ǯ--Ф
  @pages = grep(/^$name\/\d+-\d+-\d+$/,@pages);

  # ս˥
  @pages = sort {
    $a=~/^$name\/(\d+)-(\d+)-(\d+)$/;
    my $a_tmp = sprintf("%04d%02d%02d",$1,$2,$3);

    $b=~/^$name\/(\d+)-(\d+)-(\d+)$/;
    my $b_tmp = sprintf("%04d%02d%02d",$1,$2,$3);

    return $b_tmp<=>$a_tmp;
  } @pages ;
  if ( $reverse ) {		# $reverse ʤ顢ꥹȤž
    @pages = reverse @pages;
  }

  # ̤()ΤΤϽ
  my @pages2;
  my ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime(time());
  my $today = sprintf("%04d%02d%02d",$year+1900,$mon+1,$mday);
  foreach (@pages) {
    $_=~/^$name\/(\d+)-(\d+)-(\d+)$/;
    my $tmp = sprintf("%04d%02d%02d",$1,$2,$3);
    if ( $reverse ) {
      if ($tmp >= ($today + ($ignore_today ? 1 : 0))) {
	push(@pages2,$_);
      }
    } else {
      if ($tmp <= ($today - ($ignore_today ? 1 : 0))) {
	push(@pages2,$_);
      }
    }
  }

  # calendarץ饰Ʊͤɽ
  my $q_para = quotemeta(Util::trim($para));
  foreach my $page (@pages2) {
    $page =~ /(\d+)-(\d+)-(\d+)$/;
    my $year  = $1;
    my $month = $2;
    my $day   = $3;
    my $pagetmp = $cgi->param("page");
    my $source = $wiki->get_page($page);

    if ($para ne "") {
      if ($source =~ /(\n|^)!!!\s*$q_para((.|\s|\r|\n)*?)\s*(\n!!!|$)/) {
		$buf .= $wiki->process_wiki("!!![[$year-$month-$day|$page]]\n{{include $page,$para}}\n");
		
      } elsif ($source =~ /(\n|^)!!\s*$q_para((.|\s|\r|\n)*?)\s*(\n!!|$)/) {
		$buf .= $wiki->process_wiki("!!![[$year-$month-$day|$page]]\n{{include $page,$para}}\n");
		
      } elsif ($source =~ /(\n|^)!\s*$q_para((.|\s|\r|\n)*?)\s*(\n!|$)/) {
		$buf .= $wiki->process_wiki("!!![[$year-$month-$day|$page]]\n{{include $page,$para}}\n");
		
      } else {
		$buf .= $wiki->process_wiki("!!![[$year-$month-$day|$page]]\n{{include $page}}\n");
      }
    } else {
		$buf .= $wiki->process_wiki("!!![[$year-$month-$day|$page]]\n{{include $page}}\n");
	}
    $count--;
    last unless $count;
  }
  return $buf;
}

#===============================================================================
# ʹߤκǶxɽ
# FutureCalendarȤΤǥ᥽åɤǤϤʤ⥸塼ؿȤƼ
#===============================================================================
sub make_future_pages {
  return &make_recent_pages(shift, shift, "-".(shift), shift);
}

#===============================================================================
# ϥɥ᥽å
#===============================================================================
sub do_action {
  my $self = shift;
  my $wiki = shift;
  my $cgi = $wiki->get_CGI;

  my $name     = $cgi->param("name");
  my $year     = $cgi->param("year");
  my $month    = $cgi->param("month");
  my $template = $cgi->param("template");

  if (not $wiki->page_exists($template)) {
    undef $template;
  }

  if ($name eq "" || !Util::check_numeric($year) || !Util::check_numeric($month)) {
    return $wiki->error("ѥ᡼Ǥ");

  } else {
    $wiki->set_title("$name/$year-$month");
    return &make_calendar($wiki,$year,$month,$name,$template).
      &make_month_pages($wiki,$year,$month,$name);
  }
}
1;
