#############################################################################
#
# WikiFarm¸ץ饰Ǥ
#
#############################################################################
package plugin::farm::Install;
#use strict;
#============================================================================
# Farmץ饰Υ󥹥ȡ
#============================================================================
sub install{
	my $wiki = shift;
	$wiki->add_plugin("wiki_list","plugin::farm::WikiList");
	$wiki->add_handler("CREATE_WIKI","plugin::farm::CreateWikiHandler");
	$wiki->add_handler("REMOVE_WIKI","plugin::farm::RemoveWikiHandler");
	$wiki->add_menu("Farm",$wiki->config('script_name')."?action=CREATE_WIKI",993);
	
	$wiki->add_admin_menu("WikiFarm",$wiki->config('script_name')."?action=ADMINFARM",950);
	$wiki->add_admin_handler("ADMINFARM","plugin::farm::AdminFarmHandler");
}

###############################################################################
#
# WikiFarmѤΥ᥽åɷ
#
###############################################################################
package Wiki;
use File::Copy;
use File::Path;
#==============================================================================
# ߤWiki˻Wikiޤ
#==============================================================================
sub create_wiki{
	my $self  = shift;
	my $child = shift;
	my $id    = shift;
	my $pass  = shift;
	
	# databackupǥ쥯ȥ򷡤StorageǤۤʡ
	unless($self->wiki_exists($child)){
		# ǥݡȤǥ쥯ȥ򷡤
		mkpath($self->config('data_dir'  )."/$child") or die $!;
		mkpath($self->config('backup_dir')."/$child") or die $!;
		mkpath($self->config('config_dir')."/$child") or die $!;
		mkpath($self->config('log_dir'   )."/$child") or die $!;
		
		# Υԡ
		copy($self->config('config_dir')."/".$self->config('config_file'),
		     $self->config('config_dir')."/$child/".$self->config('config_file')) or die $!;
		copy($self->config('config_dir')."/".$self->config('usercss_file'),
		     $self->config('config_dir')."/$child/".$self->config('usercss_file')) or die $!;
		copy($self->config('config_dir')."/".$self->config('plugin_file'),
		     $self->config('config_dir')."/$child/".$self->config('plugin_file')) or die $!;
		
		# 桼κʤǺΤϤäȥ줫⡦
		open(USERDAT,">".$self->config('config_dir')."/$child/".$self->config('userdat_file')) or die $!;
		print USERDAT "$id=".crypt($pass,$id)."\t0\n";
		close(USERDAT);
		
		# create_wikiեåθƤӽФ
		$self->do_hook("create_wiki");
	}
}

#==============================================================================
# Wikiޤ
#==============================================================================
sub remove_wiki {
	my $self = shift;
	my $path = shift;
	
	# ǥݡȤǥ쥯ȥ
	rmtree($self->config('data_dir'  ).$path) or die $!;
	rmtree($self->config('backup_dir').$path) or die $!;
	rmtree($self->config('config_dir').$path) or die $!;
	rmtree($self->config('log_dir'   ).$path) or die $!;
	
	# remove_wikiեåθƤӽФ
	$self->do_hook("remove_wiki");
}

#==============================================================================
# Wiki¸ߤɤĴ٤ޤ 
#==============================================================================
sub wiki_exists{
	my $self  = shift;
	my $child = shift;
	return (-d $self->config('data_dir')."/$child");
}

#==============================================================================
# WikiΥꥹȤˤ֤ޤ
#==============================================================================
sub get_wiki_list{
	my $self = shift;
	my @list = $self->search_child($self->config('data_dir'));
	return @list;
}

#==============================================================================
# WikiΥĥ꡼Ǽޤ
# ͥȤWikiե󥹤ǳǼޤ
#==============================================================================
sub search_child {
	my $self = shift;
	my $dir  = shift;
	my @dirs = ();
	my @list = ();
	
	opendir(DIR,$dir) or die $!;
	while(my $entry = readdir(DIR)){
		if(-d "$dir/$entry" && $entry ne "." && $entry ne ".."){
			push(@dirs,$entry);
		}
	}
	closedir(DIR);
	@dirs = sort @dirs;
	
	foreach my $entry (@dirs){
		push(@list,$entry);
		my @child = $self->search_child("$dir/$entry");
		if($#child>-1){
			push(@list,\@child);
		}
	}
	
	return @list;
}

1;
