###############################################################################
#
# YukiWikiν񼰤򥵥ݡȤեޥåȥץ饰
#
###############################################################################
package plugin::format::YukiWikiFormat;
use strict;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}

#==============================================================================
# FSWikiν񼰤Ѵޤ
#==============================================================================
sub convert_to_fswiki {
	my $self   = shift;
	my $source = shift;
	
	my @lines  = split(/\n/,$source);
	my $buf    = "";
	
	foreach my $line (@lines){
		if($line =~ /^\*\*\*/){
			$buf .= "!".$self->_convert_line(substr($line,3))."\n";
		} elsif($line =~ /^\*\*/){
			$buf .= "!!".$self->_convert_line(substr($line,2))."\n";
		} elsif($line =~ /^\*/){
			$buf .= "!!!".$self->_convert_line(substr($line,1))."\n";
		} elsif($line =~ "----"){
			$buf .= "----\n";
		} elsif($line =~ /^---/){
			$buf .= "***".$self->_convert_line(substr($line,3))."\n";
		} elsif($line =~ /^--/){
			$buf .= "**".$self->_convert_line(substr($line,2))."\n";
		} elsif($line =~ /^-/){
			$buf .= "*".$self->_convert_line(substr($line,1))."\n";
		} elsif($line =~ /^>/){
			$buf .= "\"\"".$self->_convert_line(substr($line,1))."\n";
		} elsif($line =~ /^[ \t]/){
			$buf .= $line."\n";
		} else {
			$buf .= $self->_convert_line($line)."\n";
		}
	}
	return $buf;
}

#==============================================================================
# ʬΥ饤񼰤Ѵޤ'''''ˡ'''''Ѵˤޤ
#==============================================================================
sub _convert_line {
	my $self = shift;
	my $line = shift;
	my $buf  = "";
	
	if($line =~ /(''')(.+?)(''')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ $buf .= $self->_convert_line($pre); }
		$buf .= "''$label''";
		if($post ne ""){ $buf .= $self->_convert_line($post); }
		
	} elsif($line =~ /('')(.+?)('')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ $buf .= $self->_convert_line($pre); }
		$buf .= "'''$label'''";
		if($post ne ""){ $buf .= $self->_convert_line($post); }
	} else {
		$buf .= $line;
	}
	return $buf;
}

#==============================================================================
# FSWikiν񼰤Ѵޤ
#==============================================================================
sub convert_from_fswiki {
	my $self   = shift;
	my $source = shift;
	my @lines  = split(/\n/,$source);
	my $buf    = "";
	
	foreach my $line (@lines){
		if($line =~ /^!!!/){
			$buf .= "*".$self->_convert_line(substr($line,3))."\n";
		} elsif($line =~ /^!!/){
			$buf .= "**".$self->_convert_line(substr($line,2))."\n";
		} elsif($line =~ /^!/){
			$buf .= "***".$self->_convert_line(substr($line,1))."\n";
		} elsif($line eq "----"){
			$buf .= "----\n";
		} elsif($line =~ /^\*\*\*/){
			$buf .= "---".$self->_convert_line(substr($line,3))."\n";
		} elsif($line =~ /^\*\*/){
			$buf .= "--".$self->_convert_line(substr($line,2))."\n";
		} elsif($line =~ /^\*/){
			$buf .= "-".$self->_convert_line(substr($line,1))."\n";
		} elsif($line =~ /^""/){
			$buf .= ">".$self->_convert_line(substr($line,2))."\n";
		} elsif($line =~ /^[ \t]/){
			$buf .= $line."\n";
		} else {
			$buf .= $self->_convert_line($line)."\n";
		}
	}
	return $buf;
}

1;
