/***************************************************************/
//
//
//		DirectX	[ billboard.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/21
/*---------------------------------------------------------------
Update : 2017/6/21
			billboard.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "billboard.h"

#include "mesh_rendererbillboard.h"
#include "vertexbuffer_manager.h"
#include "vertexbuffer.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Billboard Constructor
Billboard::Billboard( 	
	const std::string& filename,
	const float& vertical,
	const float& horizonal,
	const Color& color,
	const Vector3& pos,
	const Vector3& rot,
	const Vector3& scale,
	const Matrix& mat )
	: MeshPlane(filename,vertical,horizonal,color,pos,rot,scale,mat)

{

	// Member Clear Process

}

// Billboard Destructor
Billboard::~Billboard( )
{

	// Do Nothing!!

}

// Billboard Create Instance 
Billboard* Billboard::Create( const std::string& filename, const float& vertical,
	const float& horizonal,
	const Color& color,
	const Vector3& pos,
	const Vector3& rot,
	const Vector3& scale,
	const Matrix& mat )
{

	// Create Class Instance
	return new Billboard( filename,
		vertical,
		horizonal,
		color,
		pos,
		rot,
		scale,
		mat );

}

// Billboard Initialize
void Billboard::Init( void )
{

	// Initialize Process
	world.Identity(); 

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, 4 ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	pObject = MeshRendererBillboard::SetComponent( &pVtxBuf, &pTexture, &world );

}

// Billboard Uninitialize
void Billboard::Uninit( void )
{

	// Uninitialize Process
	MeshPlane::Uninit();

}

// Billboard Update
void Billboard::Update( void )
{

	// Update Process
	MeshPlane::Update();

}

// Billboard SetPosition
void Billboard::SetPosition( const Vector3& pos )
{

	Billboard::pos = pos;

}





