/***************************************************************/
//
//
//		DirectX	[ billboard.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/21
/*---------------------------------------------------------------
Update : 2017/6/21
			Create Header File -> billboard.h.h 
 			< Add Class Function >
				Billboard->Constructor
				Billboard->Destructor
				Billboard->Create ( static member )
				Billboard->Init
				Billboard->Uninit
				Billboard->Update
				Billboard->Draw

Update : 2017/6/21



/*-------------------------------------------------------------*/
#ifndef _BILLBOARD_H_

#define _BILLBOARD_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "meshplane.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Billboard Using Billboard
class Billboard : public MeshPlane
{
public:
	
	Billboard( 
		const std::string& filename,
		const float& vertical = 10.0f,
		const float& horizonal = 10.0f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,0),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix() );	// Billboard Constructor
	~Billboard( );						// Billboard Destructor

	static Billboard* Create( 
		const std::string& filename,
		const float& vertical = 10.0f,
		const float& horizonal = 10.0f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,0),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix() );	// Billboard Create Instance Class

	void Init( void );					// Billboard Initialize
	void Uninit( void );				// Billboard Uninitialize
	void Update( void );				// Billboard Update

	void SetPosition(					// Billboard SetPosition
		const Vector3& pos );

	/*
	virtual void SetBuffer( void );		// MeshField SetBuffer
	virtual void Resize(				// MeshField Resize
		const int vertical,
		const int horizonal );
	*/
	
private:

	// Member Variable


};


#endif	//	_BILLBOARD_H_


