/***************************************************************/
//
//
//		DirectX	[ camera.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/2
/*---------------------------------------------------------------
Update : 2017/6/2
			camera.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "camera.h"

#include "window.h"

#include "cameradx9.h"
#include "cameragl.h"

#include "renderer.h"
#include "game_manager.h"

#include "gameobject_manager.h"

#include "mouse.h"
#include "window.h"
#include "castdx9.h"

#include "system_pipeline.h"

#include "fieldmap.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

Camera* Camera::data[MAX_CAMERA] = {};
int Camera::usingNumber = -1;


// Camera Constructor
Camera::Camera( const std::string& cameraName )
	: posAt(Vector3(0,MAP_HEIGHT,0))
	, vecUp(Vector3(0,1,0))
	, view()
	, proj()
	, viewInverse()
	, viewUserInterface()
	, aspect((float)Window::SCREEN_WIDTH/Window::SCREEN_HEIGHT)
	, fov(60.0f)
	, nearClip(1.0f)
	, farClip(10000.0f)
	, name(cameraName.data())
{

	// Member Clear Process
	for( int index = 0; index < MAX_CAMERA; index++ ){
		if( data[index] == NULL ){
			data[index] = this;
			id = index;
			usingNumber = id;
			SystemPipeline::SetCamera( index+1 );
			break;
		}
	}



}

// Camera Destructor
Camera::~Camera( )
{

	// Do Nothing!!

}

// Camera Create Instance 
Camera* Camera::PlatformInstance( const std::string& cameraName )
{

	// Create Class Instance
	Renderer::TYPE type = GameManager::PlatformInfo( );

	Camera* object = nullptr;

	if( type == Renderer::RENDERER_DX9 ){
		object = new CameraDX9(cameraName);
	}
	if( type == Renderer::RENDERER_GL ){
		object = new CameraGL(cameraName);
	}
	return object;
}

// Camera Initialize
void Camera::Init( void )
{

	// Initialize Process
	pos = Vector3( 0, 250, -25 );
	vecUp = Vector3(0,0,1);

}

// Camera Uninitialize
void Camera::Uninit( void )
{

	// Uninitialize Process


}

// Camera Update
void Camera::Update( void )
{

	// Update Process
	if( InputMouse::Access()->GetAxisZ( ) ){

		Vector3 dist = posAt - pos;
		dist.y = 0;
		dist = dist.Normalize( );
		float length = InputMouse::Access()->GetAxisZ() * 0.01f;
		pos    += dist * length;
	}


	if( InputMouse::Access()->GetPress( InputMouse::MOUSE_BUTTON_RIGHT ) ){

		long ax = InputMouse::Access()->GetAxisX( );
		long ay = InputMouse::Access()->GetAxisY( );
		if( ax ){
			float rotY = 3.14f * ((float)ax / Window::SCREEN_WIDTH );

			D3DXMATRIX rot;
			D3DXMatrixRotationY( &rot, -rotY );
			pos = Vector3( D3DXVec3TransformCoord( &CastVec3(pos), &CastVec3(pos), &rot ));
			//vecUp = Vector3( D3DXVec3TransformCoord( &CastVec3(vecUp), &CastVec3(vecUp), &rot ));
		}
		if( ay ){
		
			float rotX = 3.14f * ((float)ay / Window::SCREEN_HEIGHT );

			D3DXMATRIX rot;
			D3DXMatrixRotationX( &rot, -rotX );
			pos = Vector3( D3DXVec3TransformCoord( &CastVec3(pos), &CastVec3(pos), &rot ));
			vecUp = Vector3( D3DXVec3TransformCoord( &CastVec3(vecUp), &CastVec3(vecUp), &rot ));
		}
	}

}

// Camera Set
void Camera::Set( void )
{

	// Set Process
	usingNumber = id;


}

// Camera for Billboard InvViewMtx
Matrix Camera::GetMtxView( void )
{

	return data[ usingNumber ]->viewInverse;

}

// Camera for UserInterface Matrix
Matrix Camera::GetMtxUserInterface( void )
{

	return data[ usingNumber ]->viewUserInterface;

}

// Camera Access Outside Function  
Camera* Camera::Access( const std::string& cameraName )
{

	// Search CPhoto Class
	for( int index = 0; index < MAX_CAMERA; index++ ){
		if( strcmp( data[index]->name.data(), cameraName.data() ) == 0 ){
			return data[index];
			break;
		}
	}
	return nullptr;
}

// Camera Release Class All
void Camera::ReleaseAll( void )
{

	// Release CPhoto All
	for( int index = 0; index < MAX_CAMERA; index++ ){
		if( data[index] ){
			//data[ index ] ->Uninit( );
			//SAFE_DELETE( data[ index ] )
			GameObjectManager::Release( data[index] );
			data[index] = nullptr;
		}
	}

}

// Camera Update Class All
void Camera::UpdateAll( void )
{

	// Release CPhoto All
	for( int index = 0; index < MAX_CAMERA; index++ ){
		if( data[index] ){
			data[ index ] ->Update( );
		}
	}


}


