/***************************************************************/
//
//
//		DirectX	[ camera.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/2
/*---------------------------------------------------------------
Update : 2017/6/2
			Create Header File -> camera.h.h 
 			< Add Class Function >
				Camera->Constructor
				Camera->Destructor
				Camera->Create ( static member )
				Camera->Init
				Camera->Uninit
				Camera->Update
				Camera->Draw

Update : 2017/6/2



/*-------------------------------------------------------------*/
#ifndef _CAMERA_H_

#define _CAMERA_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "vector3.h"
#include "matrix.h"

#include "gamecomponent.h"

#include "gameobject.h"

#define MAX_CAMERA (8)

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Camera Using Camera
class Camera : public GameObject
{
public:
	
	Camera( 									// Camera Constructor
		const std::string& cameraName );
	virtual ~Camera( );							// Camera Destructor

	static Camera* PlatformInstance(			// Camera Create Instance Class
		const std::string& cameraName );

	virtual void Init( void );					// Camera Initialize
	virtual void Uninit( void );				// Camera Uninitialize
	virtual void Update( void );				// Camera Update
	
	virtual void Set( void );					// Camera Set
	
	static void ReleaseAll( void );				// Camera Class Release All 
	static void UpdateAll( void );				// Camera Class Update All

	static Camera* Access(						// Camera Class Access Outside Function 
		const std::string& cameraName );
	
	static Matrix GetMtxView( void );			// Camera for Billboard InvViewMtx

 	static Matrix GetMtxUserInterface( void );	// Camera for UserInterface ViewMtx 
	
	/*static void ScreenSplit(					// Camera Screen Split ( Viewport Setting )
		const int splits );*/
	
// inline Process
public:
	
	static inline Camera* Access( const int index = 0 ){
		return data[index];
	}

protected:

	// Member Variable
	Vector3 posAt;
	Vector3 vecUp;
	
	Matrix view;
	Matrix proj;
	Matrix viewInverse;
	Matrix viewUserInterface;
	//Matrix viewPort;
	float  aspect;
	float  fov;
	
	float nearClip;
	float farClip;
	
	std::string name;
	
	int id;
	static Camera* data[MAX_CAMERA];	// Cameradata
	static int usingNumber;				// using View Camera Setting index


};


#endif	//	_CAMERA_H_


