/***************************************************************/
//
//
//		DirectX	[ castdx9.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/24
/*---------------------------------------------------------------
Update : 2017/5/24
			Create Header File -> castdx9.h.h 
 			< Add Class Function >
				CCASTDX9->Constructor
				CCASTDX9->Destructor
				CCASTDX9->Create ( static member )
				CCASTDX9->Init
				CCASTDX9->Uninit
				CCASTDX9->Update
				CCASTDX9->Draw

Update : 2017/5/24



/*-------------------------------------------------------------*/
#ifndef _CASTDX9_H_

#define _CASTDX9_H_

#include "rendererdx9.h"
#include "matrix.h"

inline D3DXMATRIX CastMtx( const Matrix& mtx )
{
	
	D3DXMATRIX matrix;
	
	for( int row = 0; row < 4; row++ ){
		for( int col = 0; col < 4; col++ ){
			matrix.m[row][col] = mtx.mtx[row][col];
			matrix.m[row][col] = mtx.mtx[row][col];
		}
	}
	return matrix;
	
}

inline Matrix CastMtx( const D3DXMATRIX& mtx )
{
	
	Matrix matrix;
	
	for( int row = 0; row < 4; row++ ){
		for( int col = 0; col < 4; col++ ){
			matrix.mtx[row][col] = mtx.m[row][col];
			matrix.mtx[row][col] = mtx.m[row][col];
		}
	}
	return matrix;
	
}

inline D3DXVECTOR3 CastVec3( const Vector3& vec )
{
	
	D3DXVECTOR3 out( vec.x, vec.y, vec.z );

	return out;

}

inline Vector3 CastVec3( const D3DXVECTOR3& vec )
{
	
	Vector3 out( vec.x, vec.y, vec.z );

	return out;

}

#endif	//	_CASTDX9_H_


