/***************************************************************/
//
//
//		DirectX	[ color.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			color.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "color.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// Color Constructor
Color::Color( )
	: r(0.0f)
	, g(0.0f)
	, b(0.0f)
	, a(0.0f)
{

	// Menber Clear Process

}

// Color Destructor
Color::~Color( )
{

	// Do Nothing!!

}

// Color Constructor
Color::Color( float r, float g, float b, float a)
	: r(r)
	, g(g)
	, b(b)
	, a(a)
{

	// Menber Clear Process

}

// Color Constructor
Color::Color( const Color& other )
{
	*this = other;
}

// Color constructor 
Color::Color( const float* ref )
{
	this->r = *ref;
	this->g = *ref;
	this->b = *ref;
	this->a = *ref;
}

// Cast < unsignded short > : for bitColor 
Color::operator ArgbColor ( ) const
{
    unsigned long dwR = r >= 1.0f ? 0xff : r <= 0.0f ? 0x00 : (unsigned long) (r * 255.0f + 0.5f);
    unsigned long dwG = g >= 1.0f ? 0xff : g <= 0.0f ? 0x00 : (unsigned long) (g * 255.0f + 0.5f);
    unsigned long dwB = b >= 1.0f ? 0xff : b <= 0.0f ? 0x00 : (unsigned long) (b * 255.0f + 0.5f);
    unsigned long dwA = a >= 1.0f ? 0xff : a <= 0.0f ? 0x00 : (unsigned long) (a * 255.0f + 0.5f);

    return (dwA << 24) | (dwR << 16) | (dwG << 8) | dwB;
}

// += Color
Color& Color::operator += ( const Color& other )
{
	r += other.r;
	g += other.g;
	b += other.b;
	a += other.a;
	return *this;
}

// -= Color
Color& Color::operator -= ( const Color& other )
{
	r -= other.r;
	g -= other.g;
	b -= other.b;
	a -= other.a;
	return *this;
}

// *= Color
Color& Color::operator *= ( float ref )
{
	r *= ref;
	g *= ref;
	b *= ref;
	a *= ref;
	return *this;
}

// /= Color
Color& Color::operator /= ( float ref )
{
	r /= ref;
	g /= ref;
	b /= ref;
	a /= ref;
	return *this;
}

// unary operators : + Color
Color Color::operator + () const
{
	return *this;
}

// - Color
Color Color::operator - () const
{
	Color other( 0, 0, 0, 0 );
	other.r = -r;
	other.g = -g;
	other.b = -b;
	other.a = -a;
	return other; 
}

// binary operators : Color + Color
Color Color::operator + ( const Color& other ) const
{
	Color color;
	color.r = r + other.r;
	color.g = g + other.g;
	color.b = b + other.b;
	color.a = a + other.a;
	return color;
}

// Color - Color
Color Color::operator - ( const Color& other ) const
{
	Color color;
	color.r = r - other.r;
	color.g = g - other.g;
	color.b = b - other.b;
	color.a = a - other.a;
	return color;
}

// Color * float
Color Color::operator * ( float ref ) const
{
	Color color;
	color.r = r * ref;
	color.g = g * ref;
	color.b = b * ref;
	color.a = a * ref;
	return color;
}

// Color / float
Color Color::operator / ( float ref ) const
{
	Color color;
	color.r = r / ref;
	color.g = g / ref;
	color.b = b / ref;
	color.a = a / ref;
	return color;
}

//friend Color operator * ( float, const Color& ){}

// Color Compare Operator
bool Color::operator == ( const Color& other ) const
{
	bool result = true;
	result &= (r == other.r);
	result &= (g == other.g);
	result &= (b == other.b);
	result &= (a == other.a);
	return result;
}

// Color Compare Operator
bool Color::operator != ( const Color& other ) const
{
	return !((*this) == other);
}


