/***************************************************************/
//
//
//		DirectX	[ color.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			Create Header File -> color.h.h 
 			< Add Class Function >
				COLOR->Constructor
				COLOR->Destructor


Update : 2017/5/16



/*-------------------------------------------------------------*/
#ifndef _COLOR_H_

#define _COLOR_H_


#define ARGB_COLOR(a,r,g,b) \
    ((unsigned long)((((a)&0xff)<<24)|(((r)&0xff)<<16)|(((g)&0xff)<<8)|((b)&0xff)))

typedef unsigned long ArgbColor;					// bit color



/*---------------------------------------------------------------
	Struct
---------------------------------------------------------------*/


// Struct Color Using Color
struct Color
{
public:

	// Member Variable
	float r,g,b,a;

public:
	
	Color( );						// Color constructor
	~Color( );						// Color destructor

	Color(							// Color constructor 
		float r,
		float g,
		float b,
		float a); 
	Color(const Color&);			// Color constructor 
    Color( const float * );

    // casting
    operator ArgbColor () const;

    operator float* ();
    operator const float* () const;

    // assignment operators
    Color& operator += ( const Color& );
    Color& operator -= ( const Color& );
    Color& operator *= ( float );
    Color& operator /= ( float );

    // unary operators
    Color operator + () const;
    Color operator - () const;

    // binary operators
    Color operator + ( const Color& ) const;
    Color operator - ( const Color& ) const;
    Color operator * ( float ) const;
    Color operator / ( float ) const;

    //friend Color operator * ( float, const Color& );

    bool operator == ( const Color& ) const;
    bool operator != ( const Color& ) const;


};


#endif	//	_COLOR_H_


