/***************************************************************/
//
//
//		DirectX	[ directsound.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/16
/*---------------------------------------------------------------
Update : 2017/6/16
			Create Header File -> directsound.h.h 
 			< Add Class Function >
				DirectSound->Constructor
				DirectSound->Destructor
				DirectSound->Create ( static member )
				DirectSound->Init
				DirectSound->Uninit
				DirectSound->Update
				DirectSound->Draw

Update : 2017/6/16



/*-------------------------------------------------------------*/
#ifndef _DIRECTSOUND_H_

#define _DIRECTSOUND_H_


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/

#include <string>
#include <dsound.h>
#include <MMSystem.h>

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class DirectSound Using DirectSound
class DirectSound
{
public:
	
	DirectSound( const std::string&, bool );// DirectSound Constructor
	~DirectSound( );						// DirectSound Destructor

	static DirectSound* Create(				// DirectSound Create Instance Class
		const std::string&, bool );

	void Init( void );						// DirectSound Initialize
	void Uninit( void );					// DirectSound Uninitialize
	void Update( void );					// DirectSound Update

	void Play( void );
	void Stop( void );

	void SetVolume( const LONG& value );

	HRESULT CreatePrimaryBuffer( void );			// vC}obt@̍쐬
	HRESULT CreateSoundBuffer(						// ZJ_obt@̍쐬
		const char *file );							// >> t@C( t@Cl[萔 )


private:

	// Member Variable
	static LPDIRECTSOUND8      lpDS;			// DirectSound8̃|C^
	static LPDIRECTSOUNDBUFFER lpPrimary;		// vC}TEhobt@
	LPDIRECTSOUNDBUFFER lpSecondary;			// ZJ_TEhobt@

	LONG volume;								// {[l
	bool loop;									// [vtO

};


#endif	//	_DIRECTSOUND_H_


