/***************************************************************/
//
//
//		DirectX MaltiMedia Sample	[ dshowtexture.h ]
//
//										Author	kazuki tanaka
//										Date	2017 1/30
/*---------------------------------------------------------------
Update : 2017/1/30
			Create -> dshowtexture.h
			Create Class -> CTextureRenderer
						Inheritance to CBaseVideoRenderer

/*-------------------------------------------------------------*/

#ifndef _DSHOWTEXTURE_H_

#define _DSHOWTEXTURE_H_

#pragma comment (lib,"d3d9.lib")
#pragma comment (lib,"d3dx9.lib")
#pragma comment (lib,"dxguid.lib")
#pragma comment (lib,"winmm.lib")				// VXe擾ɕKv
#pragma comment (lib,"dinput8.lib")
//#pragma comment (lib,"User32.lib")			// }EX̃|WV̎擾ɕKv

#pragma comment(lib, "wsdapi.lib")				// v6.0 WindowsSDK library

#pragma comment(lib, "strmiids.lib")

#ifdef _DEBUG
#pragma comment(lib, "strmbasd.lib")			// DSHOWCu( _DEBUG )
#else
#pragma comment(lib, "strmbase.lib")			// DSHOWCu( _RELEASE )
#endif // DEBUG

#include <d3dx9.h>
#include <d3d9.h>
#include <d3dx9math.h>
#include <windows.h>
#include <mmsystem.h>
#include <d3d9types.h>
#include <tchar.h>
#include <strsafe.h>

#include "smartptr.h"

#include <streams.h>
#include <renbase.h>
#include <objbase.h>
#include <dshow.h>


#define TEX_RENDERER_MAX (16)							// Texture Renderer Max Number
#define SRC_NAME_MAX     (64)							// SourceName Max Number

HRESULT AddToROT(IUnknown *pUnkGraph);
void RemoveFromROT(void);

void CleanupDShow(void);
void CheckMovieStatus(void);
void Msg(TCHAR *szFormat, ...);

/*---------------------------------------------------------------
	 Define GUID for Texture Renderer
	      {71771540-2017-11cf-AE26-0020AFD79767}
---------------------------------------------------------------*/
struct __declspec(uuid("{71771540-2017-11cf-ae26-0020afd79767}")) CLSID_TextureRenderer;

/*---------------------------------------------------------------
	CTextureRenderer Class Declarations
---------------------------------------------------------------*/

class CTextureRenderer : public CBaseVideoRenderer
{
public:

    CTextureRenderer(									// Constructor
		LPUNKNOWN pUnk,
		HRESULT *phr,
		LPDIRECT3DTEXTURE9* pTexture );
    ~CTextureRenderer( );								// Destructor

	static void ReleaseAll( void );						// Release All Texture Renderer


private:

    HRESULT CheckMediaType(const CMediaType *pmt );     // Format acceptable?
    HRESULT SetMediaType(const CMediaType *pmt );       // Video format notification
    HRESULT DoRenderSample(IMediaSample *pMediaSample); // New video sample
 
private:

	LPDIRECT3DTEXTURE9* pTexture;						// Texture Pointer

	D3DFORMAT           TextureFormat;					// TextureFormat

	WCHAR sourceName[ SRC_NAME_MAX ];					// Src Name ( Using Search in Class )
	int                     myNumber;					// Class Index 							

    BOOL m_bUseDynamicTextures;
    LONG m_lVidWidth;									// Video width
    LONG m_lVidHeight;									// Video Height
    LONG m_lVidPitch;									// Video Pitch

	
	static CTextureRenderer* pTexRenderer[ TEX_RENDERER_MAX ];		// Texture Render 
	SmartPtr<IGraphBuilder>  pGraphBuilder;				// GraphBuilder

};

#endif // _DSHOWTEXTURE_H_