// Scene Script
#ifndef _GAME_H_
#define _GAME_H_


#include "system_component.h"
#include "scene.h"

#include "camera.h"
#include "meshfield.h"
#include "light.h"
#include "photo.h"

#include "fieldmap.h"

#include "particle.h"
#include "explosion.h"

#include "model.h"
#include "immortal.h"


// namespace package GameScene
namespace GameScene{
	
	
	// Class SampleScene Using SampleScene
	class Game : public Scene
	{
	private:

		// Member Variable
		MeshField* meshField;
		FieldMap*  map;

		Base* object[NUM_OBJECT];
		
	public:

		Game():meshField(nullptr),map(nullptr)
		{
			for( int index = 0; index < NUM_OBJECT; index++ )
				object[index] = nullptr;
		}
		
		// Initialize Method
		void Init( void ) override{
		
			// Member Clear Process
			map = FieldMap::Create( );
			map->Init( "stage3_clear_debug.txt" );

			// Initialize Process
			meshField = MeshField::Create( );
			meshField->Init( );

			CPhoto::Create("effect")->Init();
			Camera::PlatformInstance("mainCamera");
			Camera::Access()->Init();

			CLight::Create( "Directional" );

			InitParticle();
			InitExplosion();

			// ̐ݒu
			/*
			object[0] = Model::Instance<Immortal>( 
				"" ,								// f
				Vector3( 0,0,0));					// W(3)
			*/
		}
		
		// Uninitialize Method
		void Uninit( void ) override{
		
			// Uninitialize Process
			meshField->Uninit();
			delete meshField;

			map->Uninit();

			for( int index = 0; index < NUM_OBJECT; index++ ){
				if( object[index] ){
					object[index]->Uninit();
					SAFE_DELETE(object[index])
				}
			}

			UninitParticle();
			UninitExplosion();

			CLight::ReleaseAll( );
			Camera::ReleaseAll( );
			CPhoto::ReleaseAll();
		}
		
		// Update Method
		void Update( void ) override{
		
			meshField->Update( );

			map->Update();

			for( int index = 0; index < NUM_OBJECT; index++ ){
				if( object[index] ){
					object[index]->Update();
				}
			}

			UpdateParticle();
			UpdateExplosion();


			CPhoto::Access()->SetPhoto();
		}

		void Draw( void ) override{
		
			DrawParticle();
		}

	};
	
};


#endif	//	_GAME_H_


