/***************************************************************/
//
//
//		DirectX	[ gamemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			gamemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "window.h"
#include "game_manager.h"

// for Graphic Library
#include "renderer_manager.h"
#include "renderer.h"

// for Input system
#include "input.h"
#include "keyboard.h"
#include "mouse.h"
#include "gamepad.h"

// for
#include "system_pipeline.h"

// for debug 
#include "d_manager.h"
#include "d_font.h"
#include "d_log.h"
#include "d_console.h"

#include "imgui.h"
#include "imgui_impl_dx9.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

GameManager* GameManager::pManager = nullptr;


bool show_test_window = true;
bool show_another_window = false;
ImVec4 clear_col = ImColor(114, 144, 154);



// GameManager Constructor
GameManager::GameManager( )
	: pRendererManager( nullptr )
	, gameMaster( nullptr )
	, pipeline(nullptr)
{

	// Menber Clear Process
	if( !pManager ){
		pManager = this;
	}

}

// GameManager Destructor
GameManager::~GameManager( )
{

	// Do Nothing!!

}

// GameManager Create Instance 
GameManager* GameManager::Create( void )
{

	// Create Class Instance
	return new GameManager;

}

// GameManager Initialize
void GameManager::Init( HWND hWnd, bool bWindow )
{

	// Initialize Process
	
	{ // Renderer Initialize
		
		pRendererManager = RendererManager::Create( Renderer::RENDERER_DX9 );	// DirectX9 Platform
		pRendererManager->Init( );
		pRendererManager->GetRenderer( )->Init( hWnd, bWindow );
		platform = pRendererManager->ConfirmRendererType( );
	}

	{ // Input COM Initialize

		// get [ HINSTANCE ]
		HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );
		CInputKeyboard::Create( "keyboard" )->Init( hInstance, hWnd );
		InputMouse::Create( )->Init( hInstance, hWnd );
	}

	{ // Scene Manager Initialize

		pipeline = SystemPipeline::Create();
		pipeline->Init();
	}

	{ // DebugManager Initialize

		CDebugManager::Create( ) ->Init( );
		//Console::OpenConsole( );
	}

	ImGui_ImplDX9_Init(hWnd, GetDevice());



}

// GameManager Uninitialize
void GameManager::Uninit( void )
{

    ImGui_ImplDX9_Shutdown();

	{ // Scene Manager Uninialize

		pipeline->Uninit();
	}

	{ // Release Input
		CInput::ReleaseAll( );
	}

	{ // TEhfoCX
		//CModelManager::UnloadAll( );
		//CLight::ReleaseAll( );
	}

	{ // Release Debug Manager
		Console::CloseConsole( );
		CDebugManager::ReleaseAll( );
	}

	{ // Renderer Uninitialize
		pRendererManager->GetRenderer( )->Uninit( );
		pRendererManager->Uninit( );
		SAFE_DELETE( pRendererManager )
	}

	// GameManager Destory
	SAFE_DELETE( pManager )

}

// GameManager Update
void GameManager::Update( void )
{

	CDebugManager::IndexAccess(0) ->StartMeasureProcess( );

	// Update Process
	CInput::UpdateAll( );

	// Update Scene
	pipeline->Update();

	ImGui_ImplDX9_NewFrame();

    // 1. Show a simple window
    // Tip: if we don't call ImGui::Begin()/ImGui::End() the widgets appears in a window automatically called "Debug"
    {
        static float f = 0.0f;
        ImGui::Text("Hello, world!");
        ImGui::SliderFloat("float", &f, 0.0f, 1.0f);
        ImGui::ColorEdit3("clear color", (float*)&clear_col);
        if (ImGui::Button("Test Window")) show_test_window ^= 1;
        if (ImGui::Button("Another Window")) show_another_window ^= 1;
        ImGui::Text("Application average %.3f ms/frame (%.1f FPS)", 1000.0f / ImGui::GetIO().Framerate, ImGui::GetIO().Framerate);
    }

    // 2. Show another simple window, this time using an explicit Begin/End pair
    if (show_another_window)
    {
        ImGui::SetNextWindowSize(ImVec2(200,100), ImGuiSetCond_FirstUseEver);
        ImGui::Begin("Another Window", &show_another_window);
        ImGui::Text("Hello");
        ImGui::End();
    }

    // 3. Show the ImGui test window. Most of the sample code is in ImGui::ShowTestWindow()
    if (show_test_window)
    {
        ImGui::SetNextWindowPos(ImVec2(650, 20), ImGuiSetCond_FirstUseEver);
        ImGui::ShowTestWindow(&show_test_window);
    }


	
	// Update Debug Manager
	#ifdef _DEBUG
	//Console::DebugLog( "WindowFPS : %d\n", Window::GetFPS( ) );
	CDebugManager::UpdateAll( );
	#endif // _DEBUG


}

// GameManager Draw
void GameManager::Draw( void )
{


	// Draw Process
	if( pRendererManager->GetRenderer( )->RenderBegin( ) ){
	
		// Render Scene 
		pipeline->Render();

		ImGui::Render();

		//#ifdef _DEBUG
		CDebugManager::IndexAccess(0) ->EndMeasureProcess( );
		Vector2 screen = InputMouse::Access()->GetPosWorld();
		CDebugFont::Access()->SetRenderData( L_RENDER, " [ %s ] \n ALL PROCESS FPS : %d \n Mouse X:%f Y:%f Z:%d \n",  APPLICATION_NAME, Window::GetFPS( ), screen.x, screen.y, InputMouse::Access()->GetAxisZ() );
		CDebugFont::Access()->Render( );
		CDebugManager::DrawAll( );
		//#endif // _DEBUG

		pRendererManager->GetRenderer( )->RenderEnd( );
	}
	pRendererManager->GetRenderer( )->Present( ); 


}

// GameManager Operate
GameManager* GameManager::Operate( void )
{

	// GameManager Operate
	return pManager;

}
 
// GameManager GetRendererManager
RendererManager* GameManager::GetRendererManager( void )
{

	return pRendererManager;

}

// GameManager Device Info
Renderer* GameManager::DeviceInfo( void )
{

	// GameManager Device Info 
	return  pManager->GetRendererManager( )->GetRenderer( );

}

// GameManager Platform 
Renderer::TYPE& GameManager::PlatformInfo( void )
{

	// GameManager Platform 
	return pManager->platform;

}






