/***************************************************************/
//
//
//		DirectX	[ gamemanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			Create Header File -> gamemanager.h.h 
 			< Add Class Function >
				GAMEMANAGER->Constructor
				GAMEMANAGER->Destructor
				GAMEMANAGER->Create ( static member )
				GAMEMANAGER->Init
				GAMEMANAGER->Uninit
				GAMEMANAGER->Update
				GAMEMANAGER->Draw

Update : 2017/5/11



/*-------------------------------------------------------------*/
#ifndef _GAMEMANAGER_H_

#define _GAMEMANAGER_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <Windows.h>
#include "renderer.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#ifndef SAFE_DELETE
#define SAFE_DELETE(p)       { if (p) { delete (p);     (p)=NULL; } }
#endif

#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(p) { if (p) { delete[] (p);   (p)=NULL; } }
#endif


class GameMaster;
class RendererManager;

class SystemPipeline;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class GameManager Using GameManager
class GameManager
{
public:

	GameManager( );								// GameManager constructor
	~GameManager( );							// GameManager destructor

	static GameManager* Create( void );			// GameManager Create Instance Class

	void Init(									// GameManager Initialize
		HWND hWnd,
		bool bWindow );	
	void Uninit( void );						// GameManager Uninitialize
	void Update( void );						// GameManager Update
	void Draw( void );							// GameManager Draw

	static GameManager* Operate( void );		// GameManager Operate
	static Renderer::TYPE& PlatformInfo( void );	// GameManager Platform 

	RendererManager* GetRendererManager( void );// GameManager GetRendererManager

	Renderer* DeviceInfo( void );				// GameManager DeviceInfo

private:

	// Member Function
	GameMaster*      gameMaster;
	RendererManager* pRendererManager;
	Renderer::TYPE   platform;

	SystemPipeline*  pipeline;

	static GameManager* pManager;

};


#endif	//	_GAMEMANAGER_H_




