/***************************************************************/
//
//
//		DirectX	[ gameobject.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/5
/*---------------------------------------------------------------
Update : 2017/6/5
			gameobject.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "gameobject.h"

//#include "game_component.h"
#include "gameobject_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// GameObject Constructor
GameObject::GameObject( const Vector3& pos, const Vector3& rot, const Vector3& scale, const Matrix& mat )
	: world( mat )
	, parent( nullptr )
	, pos( pos )
	, rot( rot )
	, scale( scale )
	, pBehaviour()
{
	
	// Member Clear Process
	GameObjectManager::Registry(this);
	
}

// GameObject Destructor
GameObject::~GameObject( )
{
	
	// Do Nothing!!
	
}

// GameObject Create Instance 
GameObject* GameObject::Create( void )
{

	// Create Class Instance
	return new GameObject;

}

// GameObject Initialize
void GameObject::Init( void )
{

	// Initialize Process


}

// GameObject Uninitialize
void GameObject::Uninit( void )
{

	// Uninitialize Process
	

}

// GameObject Update
void GameObject::Update( void )
{

	// Update Process

}

// GameObject OnContactReCalcMatrix
void GameObject::OnContact( void )
{

	// Object Contact Process

}

// GameObject GetPosition
Vector3& GameObject::SetPosition( const Vector3& pos )
{
	GameObject::pos = pos;
	return GameObject::pos;
}

// GameObject GetPosition
Vector3& GameObject::GetPosition( void )
{
	return pos;
}

// GameObject GetMatrix
Matrix GameObject::GetMatrix( void )
{
	return world;
}

// GameObject SetParent
void GameObject::SetParent( GameObject* pObject )
{
	parent = pObject;
}

// GameObject Ref Parentage
void GameObject::ParentageProcess( void )
{
	
	if( parent ){
		world = world * parent->GetMatrix();
	}
	
}

// GameObject WorldMatrix ReCalclation
void GameObject::ReCalcMatrix( void )
{

	world.Identity();
	
	world.Scaling( scale );
	world.Rotate( rot );
	world.Transform( pos );

}



