/***************************************************************/
//
//
//		DirectX	[ gameobject.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/5
/*---------------------------------------------------------------
Update : 2017/6/5
			Create Header File -> gameobject.h.h 
 			< Add Class Function >
				GAMEOBJECT->Constructor
				GAMEOBJECT->Destructor
				GAMEOBJECT->Create ( static member )
				GAMEOBJECT->Init
				GAMEOBJECT->Uninit
				GAMEOBJECT->Update
				GAMEOBJECT->Draw

Update : 2017/6/5



/*-------------------------------------------------------------*/
#ifndef _GAMEOBJECT_H_

#define _GAMEOBJECT_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <vector>

#include "matrix.h"
#include "vector3.h"

class GameComponent;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class GameObject Using GameObject
class GameObject
{
public:
	
	GameObject(											// GameObject Constructor
		 const Vector3& pos = Vector3(0,0,0),
		 const Vector3& rot = Vector3(0,0,0),
		 const Vector3& scale = Vector3(1,1,1),
		 const Matrix& mat = Matrix());
	~GameObject( );										// GameObject Destructor

	static GameObject* Create( void );					// GameObject Create Instance Class

	virtual void Init( void );							// GameObject Initialize
	virtual void Uninit( void );						// GameObject Uninitialize
	virtual void Update( void );						// GameObject Update
	
	virtual void OnContact( void );						// GameObject OnContact

	Vector3& SetPosition( const Vector3& pos );			// GameObject SetPosition
	Vector3& GetPosition( void );						// GameObject GetPosition
		
	Matrix GetMatrix( void );							// GameObject GetMatrix
	void SetParent( GameObject* pObject );				// GameObject SetParent

	template<class X>X* Inheritance( void ){			// GameObject Inheritance Access
		return dynamic_cast<X*>(this);
	}

	template<class X>X* GetComponent(){					// GameObject GetComponent<X>
	
		for(int index=0; index<pBehaviour.size(); index++ ){
			if(typeid(X) == typeid(pBehaviour[index])){
				return dynamic_cast<X*>(pBehaviour[index]);
			}
		}
		return nullptr;
	}

	template<class X>void AddComponent( X* behaviour ){	// GameObject AddComponent<X>
	
		pBehaviour.push_back( behaviour );
		behaviour->SetObject(this);
	}

	void ParentageProcess( void );						// GameObject Ref Parentage
	void ReCalcMatrix( void );							// GameObject WorldMatrix ReCalclation

protected:

	// Member Variable
	Matrix world;
	GameObject* parent;
	Vector3 pos;
	Vector3 rot;
	Vector3 scale;
	std::vector<GameComponent*> pBehaviour;


};


#endif	//	_GAMEOBJECT_H_




