/***************************************************************/
//
//
//		DirectX	[ gameobjectmanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			Create Header File -> gameobjectmanager.h.h 
 			< Add Class Function >
				GameObjectManager->Constructor
				GameObjectManager->Destructor
				GameObjectManager->Create ( static member )
				GameObjectManager->Init
				GameObjectManager->Uninit
				GameObjectManager->Update
				GameObjectManager->Draw

Update : 2017/6/8



/*-------------------------------------------------------------*/
#ifndef _GAMEOBJECTMANAGER_H_

#define _GAMEOBJECTMANAGER_H_

/*---------------------------------------------------------------
	Include File + other
---------------------------------------------------------------*/

#include <vector>

class GameObject;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class GameObjectManager Using GameObjectManager
class GameObjectManager
{
public:
	
	GameObjectManager( );						// GameObjectManager Constructor
	~GameObjectManager( );						// GameObjectManager Destructor

	static GameObjectManager* Create( void );	// GameObjectManager Create Instance Class

	static void Registry( 						// GameObjectManager Registry Instance
		GameObject* object );

	static void Release(						// GameObjectManager Release Instance
		GameObject* object );
	static void ReleaseAll( void );				// GameObjectManager Release Instance
	
	static std::vector<GameObject*> GetGameObject( void );	// GameObjectManager Get<GameObject Status>

	void Uninit( void );						// GameObjectManager Uninitialize
	static void Update( void );					// GameObjectManager Update

private:

	// Member Variable
	std::vector<GameObject*> data;

	static GameObjectManager* manager;

};


#endif	//	_GAMEOBJECTMANAGER_H_


