/***************************************************************/
//
//
//		DirectX	[ grid.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/22
/*---------------------------------------------------------------
Update : 2017/6/22
			Create Header File -> grid.h.h 
 			< Add Class Function >
				Grid->Constructor
				Grid->Destructor
				Grid->Create ( static member )
				Grid->Init
				Grid->Uninit
				Grid->Update
				Grid->Draw

Update : 2017/6/22



/*-------------------------------------------------------------*/
#ifndef _GRID_H_

#define _GRID_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "vertex3d.h"

#include "matrix.h"
#include "color.h"

class RenderInterface;
class VertexBuffer;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/

#define GRID_FVF_FORMAT ( D3DFVF_XYZ | D3DFVF_DIFFUSE )

class GridVertex 
{
public:
	Vector3 pos;
	unsigned long color;
};


// Class Grid Using Grid
class Grid
{
public:
	
	Grid( 							// Grid Constructor
		const Color& color = Color( 0.3, 1.0, 0.3, 1.0 ),
		const int& vertical = 9,
		const int& horizonal = 9,
		const int& size = 5,
		const Matrix& mtx = Matrix( ) );
	~Grid( );						// Grid Destructor

	static Grid* Create( 			// Grid Create Instance Class
		const Color& color = Color( 0.3, 1.0, 0.3, 1.0 ),
		const int& vertical = 9,
		const int& horizonal = 9,
		const int& size = 5,
		const Matrix& mtx = Matrix( ) );

	void Init( void );				// Grid Initialize
	void Uninit( void );			// Grid Uninitialize
	void Update( void );			// Grid Update
	
	void SetBuffer( void );
	
	void SetColor( 
		const Color& color );

	void Lock( GridVertex* pVtx );
	void Unlock( void );

private:

	// Member Variable
	RenderInterface* renderer;
	VertexBuffer* pVtxBuf;
	Matrix mtx;
	Color color;
	int horizonal;
	int vertical;
	int size;

};


#endif	//	_GRID_H_


