/***************************************************************/
//
//
//		DirectX	[ menulist.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/23
/*---------------------------------------------------------------
Update : 2017/6/23
			Create Header File -> menulist.h.h 
 			< Add Class Function >
				MenuList->Constructor
				MenuList->Destructor
				MenuList->Create ( static member )
				MenuList->Init
				MenuList->Uninit
				MenuList->Update
				MenuList->Draw

Update : 2017/6/23



/*-------------------------------------------------------------*/
#ifndef _MENULIST_H_

#define _MENULIST_H_


/*---------------------------------------------------------------
	Include 
---------------------------------------------------------------*/

#include "vector2.h"
#include "color.h"
#include "window.h"

class UserInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MenuList Using MenuList
class MenuList
{
public:
	
	MenuList(							// MenuList Constructor
		float percent = 1.0f,				// @ ǂꂭ炢̊Ń|So..
		float padding = 0.0f );				// @ JԊu
	~MenuList( );						// MenuList Destructor

	static MenuList* Create( 
		float percent = 1.0f, 
		float padding = 0.0f );			// MenuList Create Instance Class
		
	void Init(							// MenuList Initialize
		const char* TEXTURE_NAME[ ],
		int number,
		const Vector2& texSize = Vector2( WINDOW_WIDTH, WINDOW_HEIGHT ),
		const Vector2& offset = Vector2(0,0),
		const Color& color = Color(1,1,1,1),
		bool flag = 0 );
	void Uninit( void );				// MenuList Uninitialize
	void Update( void );				// MenuList Update

private:

	// Member Variable
	UserInterface** menu;
	float percent;
	float padding;
	int number;

};


#endif	//	_MENULIST_H_


