/***************************************************************/
//
//
//		DirectX	[ MeshRendererBillboard.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> MeshRendererBillboardbillboard.h.h 
 			< Add Class Function >
				MeshRendererBillboard->Constructor
				MeshRendererBillboard->Destructor
				MeshRendererBillboard->Create ( static member )
				MeshRendererBillboard->Init
				MeshRendererBillboard->Uninit
				MeshRendererBillboard->Update
				MeshRendererBillboard->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHRENDERERBILLBOARD_H_

#define _MESHRENDERERBILLBOARD_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_Interface.h"

class VertexBuffer;
class TextureInterface;
class Matrix;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererBillboard Using MeshRendererBillboard
class MeshRendererBillboard : public RenderInterface
{
public:
	
	MeshRendererBillboard( 							// MeshRendererBillboard constructor
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	~MeshRendererBillboard( );						// MeshRendererBillboard destructor

	static MeshRendererBillboard* SetComponent( 		// MeshRendererBillboard Create Instance Class
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	
	void Render( void );					// MeshRendererBillboard Draw
	

private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;
	

};



#endif	//	_MESHRENDERERBILLBOARD_H_


