/***************************************************************/
//
//
//		DirectX	[ meshcube.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> meshcube.h.h 
 			< Add Class Function >
				MeshCube->Constructor
				MeshCube->Destructor
				MeshCube->Create ( static member )
				MeshCube->Init
				MeshCube->Uninit
				MeshCube->Update
				MeshCube->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHCUBE_H_

#define _MESHCUBE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "gameobject.h"

#include "color.h"

class RenderInterface;
class VertexBuffer;
class TextureInterface;


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshCube Using MeshCube
class MeshCube : public GameObject
{
public:
	
	MeshCube(							// MeshCube Constructor
		const std::string& filename );
	~MeshCube( );						// MeshCube Destructor

	static MeshCube* Create(			// MeshCube Create Instance Class
		const std::string& filename );

	void Init( void );					// MeshCube Initialize
	void Uninit( void );				// MeshCube Uninitialize
	void Update( void );				// MeshCube Update
	
	void SetBuffer(						// MeshCube SetBuffer
		const Vector3& vec );
	void Resize(						// MeshCube Resize
		const int size,
		const int vertical,
		const int horizonal );			


private:

	// Member Variable
	RenderInterface* renderer;
	VertexBuffer* pVtxBuf;
	TextureInterface* pTexture;
	Color color;

};


#endif	//	_MESHCUBE_H_


