/***************************************************************/
//
//
//		DirectX	[ meshsphere.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> meshsphere.h.h 
 			< Add Class Function >
				CMESHSPHERE->Constructor
				CMESHSPHERE->Destructor
				CMESHSPHERE->Create ( static member )
				CMESHSPHERE->Init
				CMESHSPHERE->Uninit
				CMESHSPHERE->Update
				CMESHSPHERE->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _MESHSPHERE_H_

#define _MESHSPHERE_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <string>

#include "gameobject.h"

#include "system_component.h"

class RenderInterface;
class VertexBuffer;
class IndexBuffer;
class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshSphere Using MeshSphere
class MeshSphere : public GameObject
{
public:
	
	MeshSphere(							// MeshSphere Constructor
		const std::string& filename );
	~MeshSphere( );						// MeshSphere Destructor

	static MeshSphere* Create( 
		const std::string& filename );	// MeshSphere Create Instance Class

	void Init( void );					// MeshSphere Initialize
	void Uninit( void );				// MeshSphere Uninitialize
	void Update( void );				// MeshSphere Update

	void SetBuffer( void );				// MeshSphere SetBuffer
	void Resize(						// MeshSphere Resize
		const float radius,
		const int vertical,
		const int horizonal );


private:

	// Member Variable
	RenderInterface* renderer;
	VertexBuffer* pVtxBuf;
	IndexBuffer*  pIdxBuf;
	TextureInterface* pTexture;
	
	unsigned int horizonal;		// c
	unsigned int vertical;		// 
	float    radius;			// a
	float    theta;				// Zp
	float    phy;				// yp


};



#endif	//	_MESHSPHERE_H_


