/***************************************************************/
//
//
//		DirectX	[ objload.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			objload.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#define _CRT_SECURE_NO_WARNINGS

#include "system_component.h"

#include "rendereropengl.h"

#include <string.h>
#include <stdlib.h>

#include "material.h"

#include "objload.h"

#include "texturegl_interface.h"
#include "texture_manager.h"

#include "d_console.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

#define NUM_VERTEX  ( 4 )						
#define NUM_POLYGON ( 2 )						

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

int CountStr( FILE* fp, const char* pStr, const char* pToken );



// CObjLoad Constructor
CObjLoad::CObjLoad( )
{

	// Menber Clear Process

}

// CObjLoad Destructor
CObjLoad::~CObjLoad( )
{

	// Do Nothing!!

}

// CObjLoad Create Instance 
CObjLoad* CObjLoad::Create( void )
{

	// Create Class Instance
	CObjLoad* pObject;
	pObject = new CObjLoad;

	return pObject;

}

// ObjLoad Load File
bool CObjLoad::OBJLoad( const char* FILE_NAME, MODEL_DATA* data )
{

	FILE* fp = fopen( FILE_NAME, "r" );

	if( fp == NULL ){
		fclose(fp);
		return false;
	}

	int countV = CountStr( fp, "v" , " \n" );
	fseek( fp, 0, SEEK_SET );
	int countVt = CountStr( fp, "vt" , " \n" );
	fseek( fp, 0, SEEK_SET );
	int countVn = CountStr( fp, "vn" , " \n" );
	fseek( fp, 0, SEEK_SET );
	int countFace = CountStr( fp, "f" , " \n" );
	fseek( fp, 0, SEEK_SET );

	data->pV = new Vector3[countV];
	data->pVt = new Vector2[countVt];
	data->pVn = new Vector3[countVn];
	data->pFace = new FaceIndex[countFace*3];

	char buf[256]={};
	int fcount = 0;
	int vcount = 0;
	int vncount = 0;
	int vtcount = 0;

	while( DivideToken( fp, " \n", buf ) >= 0 ){

		if( strcmp( "v", buf ) == 0 ){
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pV[vcount].x  = (float)atof(buf);
				Console::DebugLog( "pV[%d].x : %f \n",vcount, data->pV[vcount].x );
			}
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pV[vcount].y  = (float)atof(buf);
				Console::DebugLog( "pV[%d].y : %f \n",vcount, data->pV[vcount].y );
			}
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pV[vcount].z  = (float)atof(buf);
				Console::DebugLog( "pV[%d].z : %f \n",vcount, data->pV[vcount].z );
			}
			vcount++;

		}

		if( strcmp( "vn", buf ) == 0 ){
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pVn[vncount].x  = (float)atof(buf);
				Console::DebugLog( "pVn[%d].x : %f \n",vncount, data->pVn[vncount].x );
			}
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pVn[vncount].y  = (float)atof(buf);
				Console::DebugLog( "pVn[%d].y : %f \n",vncount, data->pVn[vncount].y );
			}
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pVn[vncount].z  = (float)atof(buf);
				Console::DebugLog( "pVn[%d].z : %f \n",vncount, data->pVn[vncount].z );
			}
			vncount++;
		}

		if( strcmp( "vt", buf ) == 0 ){
			if( DivideToken( fp, " \n", buf ) > 0 ){
				data->pVt[vtcount].x  = (float)atof(buf);
				Console::DebugLog( "pVt[%d].u : %f \n",vtcount, data->pVt[vtcount].x );

			}
			if( DivideToken( fp, " \n", buf ) > 0 ){		
				data->pVt[vtcount].y  = (float)atof(buf);
				Console::DebugLog( "pVt[%d].v : %f \n",vtcount, data->pVt[vtcount].y );

			}
			vtcount++;

		}

		if( strcmp( "f", buf ) == 0 ){
			for( int j = 0; j < 3; j++ ){
				DivideToken( fp, " /\n", buf );
				data->pFace[fcount].vIndex = atoi( buf )-1;
				Console::DebugLog( "pFace[%d].v : %d \n",fcount, data->pFace[fcount].vIndex );

				DivideToken( fp, " /\n", buf );
				data->pFace[fcount].vtIndex = atoi( buf )-1;
				Console::DebugLog( "pFace[%d].vt : %d \n",fcount, data->pFace[fcount].vtIndex );

				DivideToken( fp, " /\n", buf );
				data->pFace[fcount].vnIndex = atoi( buf )-1;
				Console::DebugLog( "pFace[%d].vn : %d \n",fcount, data->pFace[fcount].vnIndex );

				fcount++;
			}
		}
	}

	data->fcount = fcount;

	fclose(fp);

	//getchar( );

	return true;

}

int CObjLoad::DivideToken( FILE* fp, const char* pToken, char* pBuf )
{

	int bufCount = 0;
	char c;
	while( (c = (char)fgetc( fp )) != EOF ){

		for( int i = 0; i < strlen( pToken ); i++ ){
	
			if( pToken[i] == c ){
				pBuf[bufCount] = 0;
				return bufCount;
			}
		}
		pBuf[bufCount++] = c;
	}

	pBuf[bufCount] = 0;
	return -1;
}

int CountStr( FILE* fp, const char* pStr, const char* pToken )
{

	int count = 0;
	char buf[256] = { };

	while( CObjLoad::DivideToken(fp, pToken, buf ) >= 0 ){
		if( strcmp( pStr, buf) == 0 ){
			count++;
		}
	}

	return count;
}

// CObjLoad Initialize
void CObjLoad::Init( void )
{

	// Initialize Process
	if( !OBJLoad( "data\\miku_01.obj", &data ) ){
	
		//Uninit( );
	}

	//pTexture = TextureGLInterface::Create( );
	//pTexture->Load( "data\\miku_01.tga" );

	if( TextureManager::Load( "data\\miku_01.tga" ) ){
	//TextureManager::Load( "data\\miku_01.tga" );
		pTexture = TextureManager::Bind( "data\\miku_01.tga" );
	}

	//pTexture = pTexture->LoadFromManager( "data\\miku_01.tga" );

}

// CObjLoad Uninitialize
void CObjLoad::Uninit( void )
{

	// Uninitialize Process
	delete[] data.pFace;
	delete[] data.pVn;
	delete[] data.pVt;
	delete[] data.pV;

}

// CObjLoad Update
void CObjLoad::Update( void )
{

	// Update Process


}

// CObjLoad Draw
void CObjLoad::Draw( void )
{

	glPushMatrix( );

	glDisable( GL_LIGHTING );

	pTexture->SetTexture( );

	static  int angle = 0;

	/*
	Material mat = { };
	glMaterialfv( GL_FRONT_AND_BACK, GL_AMBIENT, (float*)&mat.ambient );
	glMaterialfv( GL_FRONT_AND_BACK, GL_DIFFUSE, (float*)&mat.diffuse );
	glMaterialfv( GL_FRONT_AND_BACK, GL_SPECULAR, (float*)&mat.specular );
	glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION, (float*)&mat.emission );
	glMaterialfv( GL_FRONT_AND_BACK, GL_SHININESS, (float*)&mat.shiness );
	*/

	// index 
	glRotated( angle , 0, 1, 0 );

	// Draw Process
	glBegin( GL_TRIANGLES );

	for( int i = 0; i < data.fcount; i++ ){
	
		glNormal3f( 
			data.pVn[data.pFace[i].vnIndex].x,
			data.pVn[data.pFace[i].vnIndex].y,
			data.pVn[data.pFace[i].vnIndex].z );
		glTexCoord2f(
			data.pVt[data.pFace[i].vtIndex].x,
			data.pVt[data.pFace[i].vtIndex].y );
		glVertex3f(
			data.pV[data.pFace[i].vIndex].x,
			data.pV[data.pFace[i].vIndex].y,
			data.pV[data.pFace[i].vIndex].z );
	}

	glEnd( );

	glPopMatrix( );

	glEnable( GL_LIGHTING );
	angle++;
	

}





