/***************************************************************/
//
//
//		DirectX	[ objload.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			Create Header File -> objload.h.h 
 			< Add Class Function >
				COBJLOAD->Constructor
				COBJLOAD->Destructor
				COBJLOAD->Create ( static member )
				COBJLOAD->Init
				COBJLOAD->Uninit
				COBJLOAD->Update
				COBJLOAD->Draw

Update : 2017/5/16



/*-------------------------------------------------------------*/
#ifndef _OBJLOAD_H_

#define _OBJLOAD_H_

#include <Windows.h>
#include <stdlib.h>
#include <stdio.h>

class TextureInterface;

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/

typedef struct{
	int vIndex;
	int vnIndex;
	int vtIndex;
}FaceIndex;


typedef struct{

	Vector3* pV;
	Vector2* pVt;
	Vector3* pVn;
	FaceIndex* pFace;
	int fcount;

}MODEL_DATA;

// class CObjLoad Using ObjLoad
class CObjLoad
{
public:
	CObjLoad( );						// CObjLoad constructor
	~CObjLoad( );						// CObjLoad destructor

	static bool OBJLoad( 
		const char* FILE_NAME, MODEL_DATA* data );

	static int DivideToken(
		FILE* fp,
		const char* pToken,
		char* pBuf );

	static CObjLoad* Create( void );	// CObjLoad Create Instance Class

	void Init( void );					// CObjLoad Initialize
	void Uninit( void );				// CObjLoad Uninitialize
	void Update( void );				// CObjLoad Update
	void Draw( void );					// CObjLoad Draw



private:

	// Member Function
	TextureInterface* pTexture;
	MODEL_DATA data;

};


#endif	//	_OBJLOAD_H_


