/***************************************************************/
//
//
//		DirectX	[particle.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 11/28
/*---------------------------------------------------------------
Update : 2016/11/28
			particle.cpp̍쐬
			func : InitParticle̒ǉ
			func : UninitParticle̒ǉ
			func : UpdateParticle̒ǉ
			func : DrawParticle̒ǉ
			func : MakeVertexParticle̒ǉ
			func : SetVertexParticleCoord̒ǉ
			func : SetVertexParticleColor̒ǉ
			func : SetVertexParticleSpriteUV̒ǉ
			func : SetVertexParticleNormal̒ǉ
			func : SetParticle̒ǉ

			Update : UpdateParticle 
						-> Z\[g̒ǉ

Update : 2016/11/28


/*---------------------------------------------------------------
	wb_[t@C
---------------------------------------------------------------*/

#define _CRT_SECURE_NO_WARNINGS_
#include <Windows.h>
#include <stdio.h>
#include <time.h>
#include "main.h"
#include "particle.h"

#include "photo.h"
#include "camera.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_VERTEX (4)										// _
#define NUM_INDEX  (6)										// _CfbNX

#define NUM_POLYGON (2)										// |S

#define NUM_PARTICLE (4096)									// qő吔
#define NUM_TEXTURE  ( 13 )

#define PARTICLE_RADIUS (5)									// qa

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

HRESULT MakeVertexParticle( LPDIRECT3DDEVICE9 pDevice );	// _̍쐬

void SetVertexParticleCoord(								// _W̐ݒ
	VERTEX_3D *pVtx,
	const int index );
void SetVertexParticleColor(								// _F̐ݒ
	VERTEX_3D *pVtx,
	const int index );
void SetVertexParticleSpriteUV(								// _UVl̐ݒ
	VERTEX_3D *pVtx,
	const int index  );
void SetVertexParticleNormal(								// _@ݒ 
	VERTEX_3D* pVtx,
	const int index );

												
/*----------------------------------------------------------------
	X^eBbNoϐ錾
----------------------------------------------------------------*/

int PARTICLE::PARTICLE_MAX = NUM_PARTICLE;						// p[eBNő吔
int PARTICLE::LOAD_TEXTURE  = 0;

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9      g_pTextureParticle[256];				// eNX`-C^[tF-Xp
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferParticle    = nullptr;		// _obt@C^[tF[Xւ̃|C^

PARTICLE                particle[ NUM_PARTICLE ] = {};

bool addCalcFlag = true;
bool subCalcFlag = false;
bool rotationFlag = false;

//@t@Cl[萔

char* TEXTURE_NAME[ NUM_TEXTURE ] = {

	"data\\TEXTURE\\effect000.jpg",
	"data\\TEXTURE\\effect001.jpg",
	"data\\TEXTURE\\effect002.jpg",
	"data\\TEXTURE\\effect003.jpg",
	"data\\TEXTURE\\effect004.jpg",
	"data\\TEXTURE\\effect005.jpg",
	"data\\TEXTURE\\effect006.jpg",
	"data\\TEXTURE\\effect007.jpg",
	"data\\TEXTURE\\effect008.jpg",
	"data\\TEXTURE\\effect009.jpg",
	"data\\TEXTURE\\effect010.jpg",
	"data\\TEXTURE\\effect011.jpg",
	"data\\TEXTURE\\effect012.jpg",
};





// PARTICLȄ
void InitParticle( void )
{

	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// _̏
	srand( ( unsigned int ) time( NULL ) );

	// p[eBNXe[^X̏
	for( int index = 0; index < PARTICLE::PARTICLE_MAX ; index++ ){

		particle[ index ].center   = D3DXVECTOR3( 10.0f, 10.0f, 100.0f );
		particle[ index ].speed    = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
		particle[ index ].velocity = D3DXVECTOR3( 1.0f, 1.0f, 1.0f );
		particle[ index ].scale    = D3DXVECTOR3( 1.0f, 1.0f, 1.0f );

		particle[ index ].life     = 0; 
		particle[ index ].age      = 0;
		particle[ index ].radius   = PARTICLE_RADIUS;
		particle[ index ].color    = D3DXCOLOR( 0.5f, 0.2f, 0.8f, 1.0f ); 

		particle[ index ].ambientPower = D3DXVECTOR3( 0, 0 ,0 );
		particle[ index ].texIndex = 0;				// TEXTUREftHgݒ

	} // -> INTIALIZE PARTICLE


	// _obt@̍쐬
	MakeVertexParticle( pDevice );

	// eNX`̓ǂݍ 
	for( int index = 0; index < NUM_TEXTURE; index++ ){
		HRESULT hres = D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME[index], &g_pTextureParticle[index] );
		if( FAILED( hres )){
			#ifdef _DEBUG
			MessageBox( NULL, "eNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
			#endif	// _DEBUG
		}else{
			PARTICLE::LOAD_TEXTURE++;
		}
	}
	


}

// PARTICLȄI
void UninitParticle( void )
{

	// PARTICLE_TEXTURẺ
	for( int index = 0; index < PARTICLE::LOAD_TEXTURE; index++ ){
		SAFE_RELEASE( g_pTextureParticle[index] )
	}
	PARTICLE::LOAD_TEXTURE = 0;

	// PARTICLE_VTXBUFFER̉
	SAFE_RELEASE( g_pVtxBufferParticle )

}

// PARTICLE̍XV
void UpdateParticle( void )
{

	VERTEX_3D* pVtx;

	// obt@bNzAhX擾
	g_pVtxBufferParticle -> Lock(0,0,(void**)&pVtx,0 );


	// p[eBN̍XV
	for( int index = 0; index < PARTICLE::PARTICLE_MAX; index++ ){

		if( particle[ index ].life ){


			{ // p[eBNp[^[̍XV

				// p[eBN݃t[̍XV
				particle[ index ].life -= 1 ;
				particle[ index ].age  += 1;

				// F̐ݒ
				particle[ index ].color.r -= particle[ index ].amountOfChangeInColor.r;
				particle[ index ].color.g -= particle[ index ].amountOfChangeInColor.g;
				particle[ index ].color.b -= particle[ index ].amountOfChangeInColor.b;
				particle[ index ].color.a -= particle[ index ].amountOfChangeInColor.a;
				if( particle[ index ].color.a < 0.0f ){
					particle[ index ].color.a = 0.0f;
				}

				// x̉Z
				particle[ index ].speed.x *= particle[ index ].velocity.x;
				particle[ index ].speed.y *= particle[ index ].velocity.y;
				particle[ index ].speed.z *= particle[ index ].velocity.z;

				// p[eBN̈ړ
				particle[ index ].center.x += particle[ index ].speed.x*sinf( particle[index].theta )*cosf( particle[index].phy );
				particle[ index ].center.y += particle[ index ].speed.y*cosf( particle[index].theta );
				particle[ index ].center.z += particle[ index ].speed.z*sinf( particle[index].theta )*sinf( particle[index].phy );

				// ͂ɂxNgϊ
				/*if( particle[ index ].age > 10 ){
					particle[ index ].center += particle[ index ].ambientPower;
				}*/

				// GtFNg̐ݒu
				SetVertexParticleColor( pVtx, index );
				SetVertexParticleCoord( pVtx, index );

			} // -> END ( PARTICLE UPDATE )
		}	// if( particle[ index ].life ) -> END
	}	// for -> END



	// obt@̃AbN
	g_pVtxBufferParticle->Unlock();


}

// PARTICLE̕`
void DrawParticle( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Wϊ[hs
	D3DXMATRIX mtxWorld;
	D3DXMATRIX mtxTranslation;
	D3DXMATRIX mtxRotarion;
	//DXMATRIX mtxScale;

	// Cg
	pDevice ->SetRenderState( D3DRS_LIGHTING, false );

	// Z̐ݒ
	if( addCalcFlag ){
		pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
		pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
		pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	}

	if( subCalcFlag ){
		pDevice ->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT );
		pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
		pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	}

	pDevice ->SetRenderState( D3DRS_ZWRITEENABLE, false );

	// Xg[
	pDevice->SetStreamSource(0,					
		g_pVtxBufferParticle,								
		0,													
		sizeof( VERTEX_3D ));						

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );


	// p[eBN̕`
	for( int index = 0; index < PARTICLE::PARTICLE_MAX; index++ ){

		if( particle[ index ].life ){

			// Pʍsւ̏( sPʍsɂ )
			D3DXMatrixIdentity( &mtxWorld );

			D3DXMatrixTranslation( &mtxTranslation, particle[index].center.x, particle[index].center.y, particle[index].center.z );

			mtxWorld = CPhoto::GetMtxView( ) * mtxTranslation;

			// foCXɃ[hϊsݒ
			pDevice ->SetTransform( D3DTS_WORLD, &mtxWorld );

			// eNX`̐ݒ
			pDevice->SetTexture( 0, g_pTextureParticle[particle[index].texIndex] );
		
			// `揈
			pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, NUM_VERTEX*index, NUM_POLYGON );
		
		}
	}

	// ̏Ԃɖ߂
	pDevice ->SetRenderState( D3DRS_ZWRITEENABLE, true );

	//pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );

	if( subCalcFlag ){
		pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
	}
	pDevice ->SetRenderState( D3DRS_LIGHTING, true );

}

// _̍쐬
HRESULT MakeVertexParticle( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_3D *pVtx;												// zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_3D) * NUM_VERTEX * PARTICLE::PARTICLE_MAX,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,										// gp@
			FVF_VERTEX_3D,											// gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,										// obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferParticle,									// i[|C^
			NULL)))
	{
		#ifdef _DEBUG
		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		#endif	// _DEBUG
		return E_FAIL;
	}


	// obt@bNzAhX擾
	g_pVtxBufferParticle -> Lock(0,0,(void**)&pVtx,0);				// GPUVRAMւ̑bN


	// _obt@[̐ݒ
	for( int index = 0; index < PARTICLE::PARTICLE_MAX; index++ ){

		// _W̐ݒ
		SetVertexParticleCoord( pVtx , index );

		// _F̐ݒ
		SetVertexParticleColor( pVtx , index );

		// _UVl̐ݒ
		SetVertexParticleSpriteUV( pVtx , index );

		// @̐ݒ
		SetVertexParticleNormal( pVtx, index );


	} // ->VTX SETTING END

	// obt@̃AbN
	g_pVtxBufferParticle->Unlock( );

	return S_OK;

}

// p[eBNWݒu
void SetVertexParticleCoord( VERTEX_3D *pVtx , const int index )
{


	// pVtx     >> zAhX
	// arryycenter >> ǂ̔Ԗڂ̃GtFNg...


	D3DXVECTOR2 start,end;			//n_ƏI_


	// WvZparticle
	start.x = -particle[ index ].radius;
	start.y = +particle[ index ].radius;
	end.x   = +particle[ index ].radius;
	end.y   = -particle[ index ].radius;


	// _W̐ݒ
	pVtx[ 0 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, start.y, 0.0f);
	pVtx[ 1 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   start.y, 0.0f);
	pVtx[ 2 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, end.y,   0.0f);
	pVtx[ 3 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   end.y,   0.0f);


}

// p[eBNFύX֐
void SetVertexParticleColor( VERTEX_3D *pVtx , const int index )
{
	
	// ̕ύX
	pVtx[ 0 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 1 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 2 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 3 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	

}

// p[eBNUVl̃Zbg
void SetVertexParticleSpriteUV( VERTEX_3D *pVtx , const int index  )
{

	pVtx[ 0 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[ 1 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[ 2 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[ 3 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 1.0f );

}

// p[eBN̖@ݒ
void SetVertexParticleNormal( VERTEX_3D* pVtx, const int index )
{

	pVtx[0 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
	pVtx[1 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
	pVtx[2 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
	pVtx[3 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );

}

// p[eBN̐ݒu
void SetParticle( const LPD3DXVECTOR3 center, const LPD3DXVECTOR3 velocity, const LPD3DXCOLOR color, const float radius, const unsigned int life )
{

	// q̐ݒu
	for( int index = 0; index < PARTICLE::PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   = *center;

				// p[eBN̑x
				//particle[ index ].speed    = D3DXVECTOR3( ((rand()%100)-50)*0.01f, ((rand()%100)-50)*0.01f, ((rand()%100)-50)*0.01f ); 
				particle[ index ].speed    = *velocity;

				// p[eBN̉x
				particle[ index ].velocity = *velocity;

				// p[eBNopxݒ
				particle[ index ].theta   = ((( rand( )%628 ) + 157 ) - 314 ) * 0.01f;
				particle[ index ].phy     = ((( rand( )%628 ) + 314 ) - 314 + 157 ) * 0.01f;

				// p[eBNF̐ݒ
				particle[ index ].color    = *color;

				// p[eBNa
				particle[ index ].radius   =  radius;

				// p[eBN̑݃t[
				particle[ index ].life     =  life;				

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.a  *= 0.1f;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = particle[ index ].radius / particle[ index ].life;
			
			} // -> END ( PARTICLE SET )

			break;
		}
	}

}

// p[eBN̐ݒu
void SetParticleEx( const LPD3DXVECTOR3 center, const LPD3DXVECTOR3 speed, const LPD3DXVECTOR3 velocity, const LPD3DXCOLOR color, const float radius, const int theta, const int theta_offset, const int phy, const int phy_offset, const unsigned int life, const int texIndex )
{

	// q̐ݒu
	for( int index = 0; index < PARTICLE::PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   = *center;

				// p[eBN̑x
				//particle[ index ].speed    = D3DXVECTOR3( ((rand()%100)-50)*0.01f, ((rand()%100)-50)*0.01f, ((rand()%100)-50)*0.01f ); 
				particle[ index ].speed    = *speed;

				// p[eBN̉x
				particle[ index ].velocity = *velocity;

				// p[eBNopxݒ
				particle[ index ].theta   = ((( rand( )%theta ) + theta_offset + 157 ) - 314 )       * 0.01f;
				particle[ index ].phy     = ((( rand( )%phy )   + phy_offset + 314 )   - 314 + 157 ) * 0.01f;

				// p[eBNF̐ݒ
				particle[ index ].color    = *color;

				// p[eBNa
				particle[ index ].radius   =  radius;

				// p[eBN̑݃t[
				particle[ index ].life     =  life;		

				// p[eBNeNX`̃CfbNX
				particle[ index ].texIndex = texIndex;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.a  *= 0.1f;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = particle[ index ].radius / particle[ index ].life;
			
			} // -> END ( PARTICLE SET )

			break;
		}
	}


}

// p[eBNeNX`̎擾
char** GetTextureParticle( void )
{

	return TEXTURE_NAME;

}

// eNX`̓ǂݍ
void TextureLoad( const LPTSTR TEXTURE_FILE_NAME )
{

	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	HRESULT hres = D3DXCreateTextureFromFile( pDevice, TEXTURE_FILE_NAME, &g_pTextureParticle[PARTICLE::LOAD_TEXTURE] );
	if( FAILED( hres )){
		#ifdef _DEBUG
		MessageBox( NULL, "eNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}else{

		char filename[255] = { };		// t@Cl[
		char extension[255] ={ };		// gq
	
		// pX̐؂o
		_splitpath( TEXTURE_FILE_NAME, NULL, NULL, filename, extension );
		
		// t@Cl[̏o
		sprintf(  TEXTURE_FILE_NAME, "%s%s", filename , extension );

		sprintf( &TEXTURE_NAME[PARTICLE::LOAD_TEXTURE][0], "%s", TEXTURE_FILE_NAME );
		
		//MessageBox( NULL, *buf, "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		PARTICLE::LOAD_TEXTURE++;
	}

}

// ZtO̎擾
void SetAddCalcRender( const bool flag )
{
	addCalcFlag = flag;
}

// ZtO̎擾
void SetSubCalcRender( const bool flag )
{
	subCalcFlag = flag;
}

// ^p[eBN
void EmitExplosion( D3DXVECTOR3 center, const float radius, D3DXVECTOR3 speed, const D3DXVECTOR3 velocity, const D3DXCOLOR color, const D3DXCOLOR colorValue, const int life, const int scale )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for ( int index = 0; index < NUM_PARTICLE; index++ ) {

		if ( !particle[index].life ) {


			{ // p[eBNp[^[̐ݒ

				// p[eBN̑݃t[
				particle[index].life = life;

				// p[eBNSW
				float angle  = ((rand() % 628) - 314) * 0.01f;
				float phy    = ((rand() % 628) - 314) * 0.01f;
				float length = ( float )( rand( )%scale );

				center.x = center.x + scale * sinf( angle )*cosf( phy ); 
				center.y = center.y + scale * cosf( angle );
				center.z = center.z + scale * sinf( angle )*sinf( phy );

				particle[index].center = center;

				// p[eBN̑x
				speed += D3DXVECTOR3(1.0f + (((rand() % 200) - 100) * 0.001f), 1.0f + (((rand() % 200) - 100) * 0.001f), 1.0f + (((rand() % 200) - 100) * 0.001f) );


				particle[index].speed  = speed;

				// p[eBN̉x
				particle[index].velocity = velocity;

				// p[eBNړ̐ݒ
				particle[index].theta = ( (rand( ) % 628 ) - 314) * 0.01f;
				particle[index].phy   = ( (rand( ) % 628 ) - 314) * 0.01f;

				// p[eBNF
				particle[index].color = color;

				// p[eBNa
				particle[index].radius = radius;

				// p[eBNωʒ萔
				particle[index].amountOfChangeInColor.a = particle[ index ].color.a / particle[index].life;
				particle[index].amountOfChangeInRadius = (particle[ index ].radius - 10) / particle[index].life;

				// ͂̒ǉ
				//particle[ index ].ambientPower = D3DXVECTOR2( 1.7f, 0.5f );
			
				// ݃t[̏
				particle[ index ].age  = 0;


			} // -> END ( PARTICLE SET )

			break;

		}
	}


}





