/***************************************************************/
//
//
//		DirectX	[ photo.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/7
/*---------------------------------------------------------------
Update : 2017/2/7
			Create Header File -> photo.h.h 
 			< Add Class Function >
				CPhoto->Constructor
				CPhoto->Destructor
				CPhoto->Create ( static member )
				CPhoto->Access ( static member )
				CPhoto->Init
				CPhoto->Uninit
				CPhoto->Update
				CPhoto->ReleaseAll ( static member )
				CPhoto->UpdateAll  ( static member )
				CPhoto->DrawAll    ( static member )

Update : 2017/2/7



/*-------------------------------------------------------------*/
#ifndef _PHOTO_H_

#define _PHOTO_H_


#include "rendererdx9.h"

#define ASSISTANT_NUMBER (3)						// Camera Assistant Number

//#define _VIEW_LINEAR_INTERPOLATION_				// Camera( Photo ) Linear Interporation

		
#define PHOTO_MAX (4)
#define STRING_MAX (32)

class CBasePlayer;

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CPhoto Using Photo
class CPhoto
{
public:
	
	// Photo Work
	typedef enum{
		DEFAULT = 0,
		PLAYER_COMPLIANCE,
		ROLL_Y_AXIS,
	}WORK;
	
	CPhoto( );								// CPhoto constructor
	~CPhoto( );								// CPhoto destructor

	static CPhoto* Create( 					// CPhoto Create Instance Class
		const char* PHOTO_NAME );	
	static void ReleaseAll( void );			// CPhoto Class Release All 
	static CPhoto* Access(					// CPhoto Class Access Outside Function 
		const char* PHOTO_NAME );

	void Init( void );						// CPhoto Initialize
	void Uninit( void );					// CPhoto Uninitialize

	void SetPhotoWork( WORK work );			// CPhoto Set Work
	void SetPhoto( void );					// CPhoto Setup Rendering Info

	CPhoto* SetPlayerCompliance(			// CPhoto Compliance Player
		CBasePlayer* player );

	static int PhotoNumber( void );			// CPhoto 
	static D3DXMATRIX GetMtxView( void );	// CPhoto for Billboard InvViewMtx

 	static D3DXMATRIX GetMtxUserInterface( void );	// CPhoto for UserInterface ViewMtx 
	
	static void ScreenSplit(				// CPhoto Screen Split ( Viewport Setting )
		const int splits );
	
private:

	void SetViewPosition(					// CPhoto Setup View Position
		const LPD3DXVECTOR3 pos );

	// Member Function
	char photoName[ STRING_MAX ];
	int  myNumber;

	WORK         work;
		
	D3DXMATRIX   mtxProj;
	D3DXMATRIX   viewMtx;
	D3DXMATRIX	 mtxViewInverse;
	D3DXMATRIX   mtxUI;
	D3DVIEWPORT9 viewPort;
	float        aspect;

	float        g_fFov;

	D3DXVECTOR3  posEye;
	D3DXVECTOR3  posAt;
	D3DXVECTOR3  vecUp;

	float        phy;

	CBasePlayer* obj;

	D3DXVECTOR3  assistantViewEye[ASSISTANT_NUMBER];
	D3DXVECTOR3  assistantViewAt[ASSISTANT_NUMBER];
	D3DXVECTOR3  assistantViewUp[ASSISTANT_NUMBER];

	#ifdef _VIEW_LINEAR_INTERPOLATION_
	D3DXVECTOR3 posEyeDef;
	D3DXVECTOR3 posAtDef;
	#endif // _VIEW_LINEAR_INTERPOLATION_

	static CPhoto* pPhoto[ PHOTO_MAX ];
	static int usingPhotoNumber;				// using View Camera Setting index

// inline Process
public:
	
	static inline CPhoto* Access( const int index = 0 ){
	
		// Index Call back Index Process
		return pPhoto[index];
	}

};


#endif	//	_PHOTO_H_


