////////////////////////////////////////////////////////
//  lNX wb_t@C
//  Version 1.0 , 2008/3/30 , by Li Cheng
////////////////////////////////////////////////////////

#ifndef _QUATERNION_H_
#define	_QUATERNION_H_

////////////////////////////////////////////////////////
// 3xNgNX
////////////////////////////////////////////////////////
class vector_3D
{
public:
	// ***** vf
	double x;
	double y;
	double z;
	
	// ***** RXgN^
	vector_3D();
	vector_3D(double x_, double y_, double z_);
	
	// ***** Zq
	void      operator =  (vector_3D V);	//  =
	bool      operator == (vector_3D V);	//  ==
	vector_3D operator +  (vector_3D V);	// Z +
	vector_3D operator -  (vector_3D V);	// Z -
	vector_3D operator *  (double k);		// W{ *
};

// ***** XJ[ςƃxNg
// XJ[
double    DotP  (vector_3D a, vector_3D b);
// xNg
vector_3D CrossP(vector_3D a, vector_3D b);

////////////////////////////////////////////////////////
// lNX
////////////////////////////////////////////////////////
class quaternion
{
public:
	// ***** vf
	// 
	double w;
	// 
	double x;
	double y;
	double z;

	// ***** RXgN^
	quaternion();
	quaternion(double w_, double x_, double y_, double z_);
	quaternion(double w_, vector_3D V_);
	
	// ***** Zq
	void       operator =  (quaternion Q);	//  =
	bool       operator == (quaternion Q);	//  ==
	quaternion operator +  (quaternion Q);	// Z +
	quaternion operator -  (quaternion Q);	// Z -
	quaternion operator *  (quaternion Q);	// Z *
	quaternion operator *  (double k);		// W{ *

	// ***** l
    quaternion cq ();
	
	// ***** ̋̐ݒ/擾
	// ̐ݒ
	void SetReal( double w_ );
	// ̐ݒ
	void SetImage( double x_, double y_, double z_ );
	void SetImage( vector_3D V_ );
	// ̎擾
	double    Real();
	// ̎擾
	vector_3D Image();
};

// ***** fobOp
#define print_s(s)  printf( #s" = %10.3f\n", s)
#define print_v(v)  printf( #v" = (%10.3f,%10.3f,%10.3f)\n", (v).x, (v).y, (v).z)
#define print_q(q)  printf( #q" = (%10.3f,%10.3f,%10.3f,%10.3f)\n", (q).w, (q).x, (q).y, (q).z)

#endif
