/***************************************************************/
//
//
//		DirectX	[ renderermanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/10
/*---------------------------------------------------------------
Update : 2017/5/10
			renderermanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "renderer_manager.h"

#include "renderer.h"

#include "rendererdx9.h"
#include "rendereropengl.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	static member variable Initialize 
---------------------------------------------------------------*/

// Renderer 
SelectRenderer RendererManager::pCreateRendererFunc[ Renderer::RENDERER_MAX ] = {
	RendererDX9::Create,
	RendererDX9::Create,
	RendererOpenGL::Create,
};




// RendererManager Constructor
RendererManager::RendererManager( const Renderer::TYPE& type )
	: pRenderer(nullptr) 
	, rendererType( type )
{

	// Member Clear Process

}

// RendererManager Destructor
RendererManager::~RendererManager( )
{

	// Do Nothing!!

}

// RendererManager Create Instance 
RendererManager* RendererManager::Create( const Renderer::TYPE& type )
{

	// Create Class Instance
	RendererManager* pObject;
	pObject = new RendererManager( type );

	return pObject;

}

// Renderer Get Instance
Renderer* RendererManager::GetRenderer( void )
{

	// Renderer Get Instance
	return pRenderer;
	
}

// Confirm Renderer Type
Renderer::TYPE& RendererManager::ConfirmRendererType( void )
{

	// Confirm Renderer Type
	return rendererType;

}

// RendererManager Initialize
void RendererManager::Init( void )
{

	// Initialize Process
	pRenderer = pCreateRendererFunc[ rendererType ]( );

}

// RendererManager Uninitialize
void RendererManager::Uninit( void )
{

	// Uninitialize Process
	pRenderer->Uninit( );
	SAFE_DELETE( pRenderer )

}






